/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CachesRegistry {
    private final IgniteLogger log;
    private final GridCacheSharedContext cctx;
    private final ConcurrentHashMap<Integer, CacheGroupDescriptor> registeredGrps = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, DynamicCacheDescriptor> registeredCaches = new ConcurrentHashMap();
    private volatile IgniteInternalFuture<?> cachesConfPersistFuture;

    public CachesRegistry(GridCacheSharedContext cctx) {
        assert (cctx != null);
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
    }

    public IgniteInternalFuture<?> init(Map<Integer, CacheGroupDescriptor> groupDescriptors, Map<String, DynamicCacheDescriptor> cacheDescriptors) {
        this.unregisterAll();
        return this.registerAllCachesAndGroups(groupDescriptors.values(), cacheDescriptors.values());
    }

    private CacheGroupDescriptor registerGroup(CacheGroupDescriptor grpDesc) {
        return this.registeredGrps.put(grpDesc.groupId(), grpDesc);
    }

    private DynamicCacheDescriptor registerCache(DynamicCacheDescriptor desc) {
        return this.registeredCaches.put(desc.cacheId(), desc);
    }

    public CacheGroupDescriptor unregisterGroup(int grpId) {
        return this.registeredGrps.remove(grpId);
    }

    public Map<Integer, CacheGroupDescriptor> allGroups() {
        return Collections.unmodifiableMap(this.registeredGrps);
    }

    public CacheGroupDescriptor group(int grpId) {
        CacheGroupDescriptor desc = this.registeredGrps.get(grpId);
        assert (desc != null) : grpId;
        return desc;
    }

    @Nullable
    public DynamicCacheDescriptor cache(int cacheId) {
        return this.registeredCaches.get(cacheId);
    }

    @Nullable
    public DynamicCacheDescriptor unregisterCache(int cacheId) {
        return this.registeredCaches.remove(cacheId);
    }

    public Map<Integer, DynamicCacheDescriptor> allCaches() {
        return Collections.unmodifiableMap(this.registeredCaches);
    }

    public IgniteInternalFuture<?> addUnregistered(Collection<DynamicCacheDescriptor> descs) {
        Collection grps = descs.stream().map(DynamicCacheDescriptor::groupDescriptor).filter(grpDesc -> !this.registeredGrps.containsKey(grpDesc.groupId())).collect(Collectors.toList());
        Collection caches = descs.stream().filter(cacheDesc -> !this.registeredCaches.containsKey(cacheDesc.cacheId())).collect(Collectors.toList());
        return this.registerAllCachesAndGroups(grps, caches);
    }

    public IgniteInternalFuture<?> update(ExchangeActions exchActions) {
        for (ExchangeActions.CacheGroupActionData stopAction : exchActions.cacheGroupsToStop()) {
            this.unregisterGroup(stopAction.descriptor().groupId());
        }
        for (ExchangeActions.CacheActionData req : exchActions.cacheStopRequests()) {
            this.unregisterCache(req.descriptor().cacheId());
        }
        Collection grpDescs = exchActions.cacheGroupsToStart().stream().map(ExchangeActions.CacheGroupActionData::descriptor).collect(Collectors.toList());
        Collection cacheDescs = exchActions.cacheStartRequests().stream().map(ExchangeActions.CacheActionData::descriptor).collect(Collectors.toList());
        return this.registerAllCachesAndGroups(grpDescs, cacheDescs);
    }

    public void unregisterAll() {
        this.registeredGrps.clear();
        this.registeredCaches.clear();
    }

    private void waitLastRegistration() {
        IgniteInternalFuture<?> curFut = this.cachesConfPersistFuture;
        if (curFut != null && !curFut.isDone()) {
            try {
                curFut.get();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to wait for last registered caches registration future", e);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Successfully awaited for last registered caches registration future");
            }
        }
    }

    private IgniteInternalFuture<?> registerAllCachesAndGroups(Collection<CacheGroupDescriptor> groupDescriptors, Collection<DynamicCacheDescriptor> cacheDescriptors) {
        this.waitLastRegistration();
        for (CacheGroupDescriptor grpDesc : groupDescriptors) {
            this.registerGroup(grpDesc);
        }
        for (DynamicCacheDescriptor cacheDesc2 : cacheDescriptors) {
            this.registerCache(cacheDesc2);
        }
        List cachesToPersist = cacheDescriptors.stream().filter(cacheDesc -> CU.storeCacheConfig(this.cctx, cacheDesc.cacheConfiguration())).collect(Collectors.toList());
        if (cachesToPersist.isEmpty()) {
            this.cachesConfPersistFuture = new GridFinishedFuture();
            return this.cachesConfPersistFuture;
        }
        List<StoredCacheData> cacheConfigsToPersist = cacheDescriptors.stream().map(desc -> desc.toStoredData(this.cctx.cache().splitter())).collect(Collectors.toList());
        this.cachesConfPersistFuture = this.persistCacheConfigurations(cacheConfigsToPersist);
        return this.cachesConfPersistFuture;
    }

    private IgniteInternalFuture<?> persistCacheConfigurations(final List<StoredCacheData> cacheConfigsToPersist) {
        for (StoredCacheData data : cacheConfigsToPersist) {
            try {
                FilePageStoreManager.checkAndInitCacheWorkDir(this.cctx.cache().configManager().cacheWorkDir(data.config()), this.log);
            }
            catch (IgniteCheckedException e) {
                if (this.cctx.kernalContext().isStopping()) continue;
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                U.error(this.log, "Failed to initialize cache work directory for " + data.config(), e);
            }
        }
        return this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

            @Override
            public void run() {
                try {
                    for (StoredCacheData data : cacheConfigsToPersist) {
                        CachesRegistry.this.cctx.cache().configManager().saveCacheConfiguration(data, false);
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(CachesRegistry.this.log, "Error while saving cache configurations on disk", e);
                }
            }
        });
    }
}

