/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtAtomicAbstractUpdateRequest
extends GridCacheIdMessage
implements GridCacheDeployable {
    protected static final int DHT_ATOMIC_SKIP_STORE_FLAG_MASK = 1;
    protected static final int DHT_ATOMIC_KEEP_BINARY_FLAG_MASK = 2;
    protected static final int DHT_ATOMIC_NEAR_FLAG_MASK = 4;
    static final int DHT_ATOMIC_HAS_RESULT_MASK = 8;
    private static final int DHT_ATOMIC_REPLY_WITHOUT_DELAY = 16;
    protected static final int DHT_ATOMIC_OBSOLETE_NEAR_KEY_FLAG_MASK = 32;
    protected static final int DHT_ATOMIC_TRANSFORM_OP_FLAG_MASK = 64;
    protected static final int DHT_ATOMIC_READ_REPAIR_RECOVERY_FLAG_MASK = 128;
    public static final int CACHE_MSG_IDX = GridDhtAtomicAbstractUpdateRequest.nextIndexId();
    protected long futId;
    protected GridCacheVersion writeVer;
    protected CacheWriteSynchronizationMode syncMode;
    protected AffinityTopologyVersion topVer;
    protected int taskNameHash;
    @GridDirectTransient
    protected UUID nodeId;
    @GridDirectTransient
    private boolean onRes;
    private UUID nearNodeId;
    private long nearFutId;
    protected byte flags;

    protected GridDhtAtomicAbstractUpdateRequest() {
    }

    protected GridDhtAtomicAbstractUpdateRequest(int cacheId, UUID nodeId, long futId, GridCacheVersion writeVer, CacheWriteSynchronizationMode syncMode, @NotNull AffinityTopologyVersion topVer, int taskNameHash, boolean addDepInfo, boolean keepBinary, boolean skipStore, boolean readRepairRecovery) {
        assert (topVer.topologyVersion() > 0L) : topVer;
        this.cacheId = cacheId;
        this.nodeId = nodeId;
        this.futId = futId;
        this.writeVer = writeVer;
        this.syncMode = syncMode;
        this.topVer = topVer;
        this.taskNameHash = taskNameHash;
        this.addDepInfo = addDepInfo;
        if (skipStore) {
            this.setFlag(true, 1);
        }
        if (keepBinary) {
            this.setFlag(true, 2);
        }
        if (readRepairRecovery) {
            this.setFlag(true, 128);
        }
    }

    @Override
    public final AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    void nearReplyInfo(UUID nearNodeId, long nearFutId) {
        assert (nearNodeId != null);
        this.nearNodeId = nearNodeId;
        this.nearFutId = nearFutId;
    }

    boolean replyWithoutDelay() {
        return this.isFlag(16);
    }

    void replyWithoutDelay(boolean replyWithoutDelay) {
        this.setFlag(replyWithoutDelay, 16);
    }

    void hasResult(boolean res) {
        this.setFlag(res, 8);
    }

    private boolean hasResult() {
        return this.isFlag(8);
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public final byte flags() {
        return this.flags;
    }

    public final boolean keepBinary() {
        return this.isFlag(2);
    }

    public final boolean readRepairRecovery() {
        return this.isFlag(128);
    }

    public final boolean skipStore() {
        return this.isFlag(1);
    }

    public final boolean transformOperation() {
        return this.isFlag(64);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onResponse() {
        if (this.onRes) return false;
        this.onRes = true;
        if (!true) return false;
        return true;
    }

    boolean hasResponse() {
        return this.onRes;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    public abstract boolean forceTransformBackups();

    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    @Override
    public void onAckReceived() {
        this.cleanup();
    }

    public abstract void addWriteValue(KeyCacheObject var1, @Nullable CacheObject var2, EntryProcessor<Object, Object, Object> var3, long var4, long var6, @Nullable GridCacheVersion var8, boolean var9, @Nullable CacheObject var10, long var11, GridCacheOperation var13);

    public abstract void addNearWriteValue(KeyCacheObject var1, @Nullable CacheObject var2, EntryProcessor<Object, Object, Object> var3, long var4, long var6);

    protected abstract void cleanup();

    public final int taskNameHash() {
        return this.taskNameHash;
    }

    public final long futureId() {
        return this.futId;
    }

    public final long nearFutureId() {
        return this.nearFutId;
    }

    public final GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    public final CacheWriteSynchronizationMode writeSynchronizationMode() {
        return this.syncMode;
    }

    public abstract int size();

    public abstract int nearSize();

    public abstract boolean hasKey(KeyCacheObject var1);

    public abstract KeyCacheObject key(int var1);

    public abstract int obsoleteNearKeysSize();

    public abstract KeyCacheObject obsoleteNearKey(int var1);

    public abstract Long updateCounter(int var1);

    public abstract KeyCacheObject nearKey(int var1);

    @Nullable
    public abstract CacheObject value(int var1);

    @Nullable
    public abstract CacheObject previousValue(int var1);

    @Nullable
    public abstract EntryProcessor<Object, Object, Object> entryProcessor(int var1);

    @Nullable
    public abstract CacheObject nearValue(int var1);

    @Nullable
    public abstract EntryProcessor<Object, Object, Object> nearEntryProcessor(int var1);

    @Nullable
    public abstract GridCacheVersion conflictVersion(int var1);

    public abstract long ttl(int var1);

    public abstract long nearTtl(int var1);

    public abstract long conflictExpireTime(int var1);

    public abstract long nearExpireTime(int var1);

    @Nullable
    public abstract Object[] invokeArguments();

    protected final void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    final boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    @Override
    public byte fieldsCount() {
        return 12;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("nearFutId", this.nearFutId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeUuid("nearNodeId", this.nearNodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByte("syncMode", this.syncMode != null ? (byte)this.syncMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMessage("writeVer", this.writeVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.nearFutId = reader.readLong("nearFutId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.nearNodeId = reader.readUuid("nearNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                byte syncModeOrd = reader.readByte("syncMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.syncMode = CacheWriteSynchronizationMode.fromOrdinal(syncModeOrd);
                reader.incrementState();
            }
            case 9: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.writeVer = (GridCacheVersion)reader.readMessage("writeVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAtomicAbstractUpdateRequest.class);
    }

    @Override
    public String toString() {
        StringBuilder flags = new StringBuilder();
        if (this.skipStore()) {
            this.appendFlag(flags, "skipStore");
        }
        if (this.keepBinary()) {
            this.appendFlag(flags, "keepBinary");
        }
        if (this.isFlag(4)) {
            this.appendFlag(flags, "near");
        }
        if (this.hasResult()) {
            this.appendFlag(flags, "hasRes");
        }
        if (this.replyWithoutDelay()) {
            this.appendFlag(flags, "resNoDelay");
        }
        return S.toString(GridDhtAtomicAbstractUpdateRequest.class, this, "flags", (Object)flags.toString());
    }
}

