/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdAllocator;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointPages;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.LoadedPagesMap;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageHeader;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagePool;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReplacementPolicy;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.ReplaceCandidate;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionCountersIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;

public class RandomLruPageReplacementPolicy
extends PageReplacementPolicy {
    public static final int RANDOM_PAGES_EVICT_NUM = 5;
    private static final double FULL_SCAN_THRESHOLD = 0.4;

    protected RandomLruPageReplacementPolicy(PageMemoryImpl.Segment seg) {
        super(seg);
    }

    @Override
    public long replace() throws IgniteCheckedException {
        long relRmvAddr;
        block13: {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            LoadedPagesMap loadedPages = this.seg.loadedPages();
            PagePool pool = this.seg.pool();
            int cap = loadedPages.capacity();
            HashSet<Long> ignored = null;
            relRmvAddr = 0xFFFFFFFFFFFFFFL;
            int iterations = 0;
            do {
                long cleanAddr = 0xFFFFFFFFFFFFFFL;
                long cleanTs = Long.MAX_VALUE;
                long dirtyAddr = 0xFFFFFFFFFFFFFFL;
                long dirtyTs = Long.MAX_VALUE;
                long metaAddr = 0xFFFFFFFFFFFFFFL;
                long metaTs = Long.MAX_VALUE;
                for (int i = 0; i < 5 && !((double)(++iterations) > (double)pool.pages() * 0.4); ++i) {
                    boolean outdated;
                    ReplaceCandidate nearest = loadedPages.getNearestAt(rnd.nextInt(cap));
                    assert (nearest != null && nearest.relativePointer() != 0xFFFFFFFFFFFFFFL);
                    long rndAddr = nearest.relativePointer();
                    int partGen = nearest.generation();
                    long absPageAddr = this.seg.absolute(rndAddr);
                    FullPageId fullId = PageHeader.fullPageId(absPageAddr);
                    assert (fullId.equals(nearest.fullId())) : "Invalid page mapping [tableId=" + nearest.fullId() + ", actual=" + fullId + ", nearest=" + nearest;
                    boolean bl = outdated = partGen < this.seg.partGeneration(fullId.groupId(), PageIdUtils.partId(fullId.pageId()));
                    if (outdated) {
                        return this.seg.refreshOutdatedPage(fullId.groupId(), fullId.pageId(), true);
                    }
                    boolean pinned = PageHeader.isAcquired(absPageAddr);
                    boolean skip = ignored != null && ignored.contains(rndAddr);
                    boolean dirty = PageHeader.dirty(absPageAddr);
                    CheckpointPages checkpointPages = this.seg.checkpointPages();
                    if (relRmvAddr == rndAddr || pinned || skip || fullId.pageId() == PageIdAllocator.META_PAGE_ID || dirty && (checkpointPages == null || !checkpointPages.contains(fullId))) {
                        --i;
                        continue;
                    }
                    long pageTs = PageHeader.readTimestamp(absPageAddr);
                    boolean storMeta = RandomLruPageReplacementPolicy.isStoreMetadataPage(absPageAddr);
                    if (pageTs < cleanTs && !dirty && !storMeta) {
                        cleanAddr = rndAddr;
                        cleanTs = pageTs;
                    } else if (pageTs < dirtyTs && dirty && !storMeta) {
                        dirtyAddr = rndAddr;
                        dirtyTs = pageTs;
                    } else if (pageTs < metaTs && storMeta) {
                        metaAddr = rndAddr;
                        metaTs = pageTs;
                    }
                    relRmvAddr = cleanAddr != 0xFFFFFFFFFFFFFFL ? cleanAddr : (dirtyAddr != 0xFFFFFFFFFFFFFFL ? dirtyAddr : metaAddr);
                }
                if (relRmvAddr == 0xFFFFFFFFFFFFFFL) {
                    return this.tryToFindSequentially(cap);
                }
                long absRmvAddr = this.seg.absolute(relRmvAddr);
                FullPageId fullPageId = PageHeader.fullPageId(absRmvAddr);
                if (this.seg.tryToRemovePage(fullPageId, absRmvAddr)) break block13;
                if (iterations <= 10) continue;
                if (ignored == null) {
                    ignored = new HashSet<Long>();
                }
                ignored.add(relRmvAddr);
            } while (!((double)iterations > (double)this.seg.pool().pages() * 0.4));
            return this.tryToFindSequentially(cap);
        }
        return relRmvAddr;
    }

    private static boolean isStoreMetadataPage(long absPageAddr) {
        try {
            long dataAddr = absPageAddr + 48L;
            int type = PageIO.getType(dataAddr);
            int ver = PageIO.getVersion(dataAddr);
            Object io = PageIO.getPageIO(type, ver);
            return io instanceof PagePartitionMetaIO || io instanceof PagesListMetaIO || io instanceof PagePartitionCountersIO;
        }
        catch (IgniteCheckedException ignored) {
            return false;
        }
    }

    private long tryToFindSequentially(int cap) throws IgniteCheckedException {
        assert (this.seg.getWriteHoldCount() > 0);
        long prevAddr = 0xFFFFFFFFFFFFFFL;
        LoadedPagesMap loadedPages = this.seg.loadedPages();
        for (int i = 0; i < cap; ++i) {
            long absPageAddr;
            FullPageId fullId;
            ReplaceCandidate nearest = loadedPages.getNearestAt(i);
            assert (nearest != null && nearest.relativePointer() != 0xFFFFFFFFFFFFFFL);
            long addr = nearest.relativePointer();
            int partGen = nearest.generation();
            if (partGen < this.seg.partGeneration((fullId = PageHeader.fullPageId(absPageAddr = this.seg.absolute(addr))).groupId(), PageIdUtils.partId(fullId.pageId()))) {
                return this.seg.refreshOutdatedPage(fullId.groupId(), fullId.pageId(), true);
            }
            boolean pinned = PageHeader.isAcquired(absPageAddr);
            if (addr == prevAddr || pinned) continue;
            long absEvictAddr = this.seg.absolute(addr);
            FullPageId fullPageId = PageHeader.fullPageId(absEvictAddr);
            if (this.seg.tryToRemovePage(fullPageId, absEvictAddr)) {
                return addr;
            }
            prevAddr = addr;
        }
        throw this.seg.oomException("no pages to replace");
    }
}

