/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.cache;

import java.util.Collection;
import javax.cache.CacheException;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;

/**
 * Exception thrown from non-transactional cache in case when update succeeded only partially.
 * One can get list of keys for which update failed with method {@link #failedKeys()}.
 */
public class CachePartialUpdateException extends CacheException {
    /** */
    private static final long serialVersionUID = 0L;

    /**
     * @param e Cause.
     */
    public CachePartialUpdateException(CachePartialUpdateCheckedException e) {
        super(e.getMessage(), e);
    }

    /**
     * Gets collection of failed keys.
     *
     * @param <K> Type of keys.
     * @return Collection of failed keys.
     */
    public <K> Collection<K> failedKeys() {
        return ((CachePartialUpdateCheckedException)getCause()).failedKeys();
    }
}
