/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.GridStringBuilder;

public class ProgressPrinter {
    private static final int DEFAULT_CHUNKS_NUM = 50;
    private static final int MIN_PROGRESS_BAR_LENGTH = 20;
    private static final int MAX_CAPTION_LENGTH = 40;
    private final long total;
    private long curr = 0L;
    private final int chunksNum;
    private final String caption;
    private final PrintStream printStream;
    private int lastChunkLogged = -1;
    private Long timeStarted = null;

    public ProgressPrinter(PrintStream printStream, String caption, long total) {
        this(printStream, caption, total, 50);
    }

    public ProgressPrinter(PrintStream printStream, String caption, long total, int chunksNum) {
        this.printStream = printStream;
        this.caption = caption.length() >= 40 ? caption.substring(0, 40) : caption;
        this.total = total;
        this.chunksNum = chunksNum;
    }

    public void printProgress() {
        double currRatio;
        int currChunk;
        ++this.curr;
        if (this.curr > this.total) {
            throw new RuntimeException("Current value can't be greater than total value.");
        }
        if (this.timeStarted == null) {
            this.timeStarted = System.currentTimeMillis();
        }
        if ((currChunk = (int)((currRatio = (double)this.curr / (double)this.total) * (double)this.chunksNum)) > this.lastChunkLogged || this.curr == this.total) {
            ++this.lastChunkLogged;
            this.printProgress0(this.curr, currRatio);
        }
    }

    private void printProgress0(long curr, double currRatio) {
        int progressBarLen = 20 + (40 - this.caption.length());
        String progressBarFmt = "\r%s %4s [%" + progressBarLen + "s] %-50s";
        int percentage = (int)(currRatio * 100.0);
        int progressCurrLen = (int)(currRatio * (double)progressBarLen);
        long timeRunning = System.currentTimeMillis() - this.timeStarted;
        long timeEstimated = (long)((double)timeRunning / currRatio);
        GridStringBuilder progressBuilder = new GridStringBuilder();
        for (int i = 0; i < progressBarLen; ++i) {
            progressBuilder.a(i < progressCurrLen ? "=" : " ");
        }
        long daysRunning = TimeUnit.MILLISECONDS.toDays(timeRunning);
        long daysEstimated = TimeUnit.MILLISECONDS.toDays(timeEstimated);
        String txtProgress = String.format("%s/%s (%s%s / %s%s)", curr, this.total, daysRunning > 0L ? daysRunning + " days " : "", ProgressPrinter.formatDuration(timeRunning), daysEstimated > 0L ? daysEstimated + " days " : "", ProgressPrinter.formatDuration(timeEstimated));
        String progressBar = String.format(progressBarFmt, this.caption + ":", percentage + "%", progressBuilder.toString(), txtProgress);
        this.printStream.print(progressBar);
    }

    private static String formatDuration(long durationMillis) {
        long seconds = durationMillis / 1000L % 60L;
        long minutes = durationMillis / 60000L % 60L;
        long hours = durationMillis / 3600000L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }
}

