/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.calcite.message.CalciteMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class QueryTxEntry
implements CalciteMessage {
    private int cacheId;
    private KeyCacheObject key;
    private CacheObject val;
    private GridCacheVersion ver;

    public QueryTxEntry() {
    }

    public QueryTxEntry(int cacheId, KeyCacheObject key, CacheObject val, GridCacheVersion ver) {
        this.cacheId = cacheId;
        this.key = key;
        this.val = val;
        this.ver = ver;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public CacheObject value() {
        return this.val;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    public void prepareMarshal(GridCacheSharedContext<?, ?> ctx) throws IgniteCheckedException {
        CacheObjectContext coctx = ctx.cacheContext(this.cacheId).cacheObjectContext();
        this.key.prepareMarshal((CacheObjectValueContext)coctx);
        if (this.val != null) {
            this.val.prepareMarshal((CacheObjectValueContext)coctx);
        }
    }

    public void prepareUnmarshal(GridCacheSharedContext<?, ?> ctx, ClassLoader ldr) throws IgniteCheckedException {
        CacheObjectContext coctx = ctx.cacheContext(this.cacheId).cacheObjectContext();
        this.key.finishUnmarshal((CacheObjectValueContext)coctx, ldr);
        if (this.val != null) {
            this.val.finishUnmarshal((CacheObjectValueContext)coctx, ldr);
        }
    }

    @Override
    public MessageType type() {
        return MessageType.QUERY_TX_ENTRY;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("key", (Message)this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("val", (Message)this.val)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeMessage("ver", (Message)this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.ver = (GridCacheVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryTxEntry.class);
    }

    public byte fieldsCount() {
        return 4;
    }
}

