/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionState;

public class TxRecordSerializer {
    public void write(TxRecord rec, ByteBuffer buf) {
        buf.put((byte)rec.state().ordinal());
        RecordV1Serializer.putVersion(buf, rec.nearXidVersion(), true);
        RecordV1Serializer.putVersion(buf, rec.writeVersion(), true);
        Map<Short, Collection<Short>> participatingNodes = rec.participatingNodes();
        if (participatingNodes != null && !participatingNodes.isEmpty()) {
            buf.putInt(participatingNodes.size());
            for (Map.Entry<Short, Collection<Short>> e : participatingNodes.entrySet()) {
                buf.putShort(e.getKey());
                Collection<Short> backupNodes = e.getValue();
                buf.putInt(backupNodes.size());
                for (short backupNode : backupNodes) {
                    buf.putShort(backupNode);
                }
            }
        } else {
            buf.putInt(0);
        }
        buf.putLong(rec.timestamp());
    }

    public TxRecord readTx(ByteBufferBackedDataInput in) throws IOException {
        byte txState = in.readByte();
        TransactionState state = TransactionState.fromOrdinal(txState);
        GridCacheVersion nearXidVer = RecordV1Serializer.readVersion(in, true);
        GridCacheVersion writeVer = RecordV1Serializer.readVersion(in, true);
        int participatingNodesSize = in.readInt();
        HashMap<Short, Collection<Short>> participatingNodes = U.newHashMap(participatingNodesSize);
        for (int i = 0; i < participatingNodesSize; ++i) {
            short primaryNode = in.readShort();
            int backupNodesSize = in.readInt();
            ArrayList<Short> backupNodes = new ArrayList<Short>(backupNodesSize);
            for (int j = 0; j < backupNodesSize; ++j) {
                short backupNode = in.readShort();
                backupNodes.add(backupNode);
            }
            participatingNodes.put(primaryNode, backupNodes);
        }
        long ts = in.readLong();
        return new TxRecord(state, nearXidVer, writeVer, participatingNodes, ts);
    }

    public int size(TxRecord rec) {
        int size = 0;
        ++size;
        size += CacheVersionIO.size(rec.nearXidVersion(), true);
        size += CacheVersionIO.size(rec.writeVersion(), true);
        size += 4;
        Map<Short, Collection<Short>> participatingNodes = rec.participatingNodes();
        if (participatingNodes != null && !participatingNodes.isEmpty()) {
            for (Collection<Short> backupNodes : participatingNodes.values()) {
                size += 2;
                size += 4;
                size += 2 * backupNodes.size();
            }
        }
        return size += 8;
    }
}

