/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.logger;

import java.util.Objects;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.VoidLogger;
import org.apache.ignite.lang.LoggerFactory;

public final class Loggers {
    public static IgniteLogger forClass(Class<?> cls) {
        return Loggers.forName(Objects.requireNonNull(cls, "cls").getName());
    }

    public static IgniteLogger forClass(Class<?> cls, LoggerFactory loggerFactory) {
        return Loggers.forName(Objects.requireNonNull(cls, "cls").getName(), loggerFactory);
    }

    public static IgniteLogger forName(String name) {
        System.Logger delegate = System.getLogger(name);
        return new IgniteLogger(delegate);
    }

    public static IgniteLogger forName(String name, LoggerFactory loggerFactory) {
        System.Logger delegate = Objects.requireNonNull(loggerFactory, "loggerFactory").forName(name);
        return new IgniteLogger(delegate);
    }

    public static IgniteLogger voidLogger() {
        return new VoidLogger();
    }
}

