/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.util.HashUtils;
import org.apache.ignite.lang.IgniteInternalException;

public class HashCalculator {
    private int hash = 0;

    public void append(Object v) {
        if (v == null) {
            this.appendNull();
            return;
        }
        if (v.getClass() == Byte.class) {
            this.appendByte((Byte)v);
        } else if (v.getClass() == Short.class) {
            this.appendShort((Short)v);
        } else if (v.getClass() == Integer.class) {
            this.appendInt((Integer)v);
        } else if (v.getClass() == Long.class) {
            this.appendLong((Long)v);
        } else if (v.getClass() == Float.class) {
            this.appendFloat(((Float)v).floatValue());
        } else if (v.getClass() == Double.class) {
            this.appendDouble((Double)v);
        } else if (v.getClass() == BigInteger.class) {
            this.appendNumber((BigInteger)v);
        } else if (v.getClass() == BigDecimal.class) {
            this.appendDecimal((BigDecimal)v);
        } else if (v.getClass() == UUID.class) {
            this.appendUuid((UUID)v);
        } else if (v.getClass() == LocalDate.class) {
            this.appendDate((LocalDate)v);
        } else if (v.getClass() == LocalTime.class) {
            this.appendTime((LocalTime)v);
        } else if (v.getClass() == LocalDateTime.class) {
            this.appendDateTime((LocalDateTime)v);
        } else if (v.getClass() == Instant.class) {
            this.appendTimestamp((Instant)v);
        } else if (v.getClass() == byte[].class) {
            this.appendBytes((byte[])v);
        } else if (v.getClass() == String.class) {
            this.appendString((String)v);
        } else if (v.getClass() == BitSet.class) {
            this.appendBitmask((BitSet)v);
        } else {
            throw new IgniteInternalException("Unsupported value type: [cls=" + v.getClass() + "]");
        }
    }

    public void appendNull() {
        this.appendByte((byte)0);
    }

    public void appendByte(byte v) {
        this.hash = HashUtils.hash32(v, this.hash);
    }

    public void appendShort(short v) {
        this.hash = HashUtils.hash32(v, this.hash);
    }

    public void appendInt(int v) {
        this.hash = HashUtils.hash32(v, this.hash);
    }

    public void appendLong(long v) {
        this.hash = HashUtils.hash32(v, this.hash);
    }

    public void appendFloat(float v) {
        this.appendInt(Float.floatToRawIntBits(v));
    }

    public void appendDouble(double v) {
        this.appendLong(Double.doubleToRawLongBits(v));
    }

    public void appendDecimal(BigDecimal v) {
        this.appendDouble(v.doubleValue());
    }

    public void appendNumber(BigInteger v) {
        this.appendDouble(v.doubleValue());
    }

    public void appendUuid(UUID v) {
        this.appendLong(v.getMostSignificantBits());
        this.appendLong(v.getLeastSignificantBits());
    }

    public void appendString(String v) {
        this.appendBytes(v.getBytes(StandardCharsets.UTF_8));
    }

    public void appendBytes(byte[] v) {
        this.hash = HashUtils.hash32(v, 0, v.length, this.hash);
    }

    public void appendBitmask(BitSet v) {
        this.appendBytes(v.toByteArray());
    }

    public void appendDate(LocalDate v) {
        this.appendLong(v.getYear());
        this.appendLong(v.getMonthValue());
        this.appendLong(v.getDayOfMonth());
    }

    public void appendTime(LocalTime v) {
        this.appendLong(v.getHour());
        this.appendLong(v.getMinute());
        this.appendLong(v.getSecond());
        this.appendLong(v.getNano());
    }

    public void appendDateTime(LocalDateTime v) {
        this.appendDate(v.toLocalDate());
        this.appendTime(v.toLocalTime());
    }

    public void appendTimestamp(Instant v) {
        this.appendLong(v.getEpochSecond());
        this.appendLong(v.getNano());
    }

    public int hash() {
        return this.hash;
    }

    public void reset() {
        this.hash = 0;
    }
}

