/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.rest.api.node.State;
import org.apache.ignite.internal.rest.node.StateProvider;
import org.apache.ignite.internal.util.ReverseIterator;
import org.apache.ignite.lang.NodeStoppingException;

class LifecycleManager
implements StateProvider {
    private static final IgniteLogger LOG = Loggers.forClass(LifecycleManager.class);
    private final String nodeName;
    private final AtomicReference<State> status = new AtomicReference<State>(State.STARTING);
    private final List<IgniteComponent> startedComponents = new ArrayList<IgniteComponent>();

    LifecycleManager(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public State getState() {
        return this.status.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startComponent(IgniteComponent component) throws NodeStoppingException {
        if (this.status.get() == State.STOPPING) {
            throw new NodeStoppingException("Node=[" + this.nodeName + "] was stopped");
        }
        LifecycleManager lifecycleManager = this;
        synchronized (lifecycleManager) {
            this.startedComponents.add(component);
            component.start();
        }
    }

    void startComponents(IgniteComponent ... components) throws NodeStoppingException {
        for (IgniteComponent component : components) {
            this.startComponent(component);
        }
    }

    void onStartComplete() throws NodeStoppingException {
        LOG.info("Start complete", new Object[0]);
        State currentStatus = this.status.compareAndExchange(State.STARTING, State.STARTED);
        if (currentStatus == State.STOPPING) {
            throw new NodeStoppingException();
        }
        if (currentStatus != State.STARTING) {
            throw new IllegalStateException("Unexpected node status: " + currentStatus);
        }
    }

    void stopNode() {
        State currentStatus = this.status.getAndSet(State.STOPPING);
        if (currentStatus != State.STOPPING) {
            this.stopAllComponents();
        }
    }

    private synchronized void stopAllComponents() {
        new ReverseIterator(this.startedComponents).forEachRemaining(component -> {
            try {
                component.beforeNodeStop();
            }
            catch (Exception e) {
                LOG.warn("Unable to execute before node stop [component={}, nodeName={}]", (Throwable)e, new Object[]{component, this.nodeName});
            }
        });
        new ReverseIterator(this.startedComponents).forEachRemaining(component -> {
            try {
                component.stop();
            }
            catch (Exception e) {
                LOG.warn("Unable to stop component [component={}, nodeName={}]", (Throwable)e, new Object[]{component, this.nodeName});
            }
        });
    }
}

