/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InternalConfiguration;
import org.apache.ignite.internal.tostring.S;

public class RootKey<T extends ConfigurationTree<VIEWT, ?>, VIEWT> {
    private final String rootName;
    private final ConfigurationType storageType;
    private final Class<?> schemaClass;
    private final boolean internal;

    public RootKey(Class<?> schemaClass) {
        this.schemaClass = schemaClass;
        ConfigurationRoot rootAnnotation = schemaClass.getAnnotation(ConfigurationRoot.class);
        assert (rootAnnotation != null);
        this.rootName = rootAnnotation.rootName();
        this.storageType = rootAnnotation.type();
        this.internal = schemaClass.isAnnotationPresent(InternalConfiguration.class);
    }

    public String key() {
        return this.rootName;
    }

    public ConfigurationType type() {
        return this.storageType;
    }

    public Class<?> schemaClass() {
        return this.schemaClass;
    }

    public boolean internal() {
        return this.internal;
    }

    public String toString() {
        return S.toString(RootKey.class, (Object)this);
    }
}

