/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;

@Singleton
@Requires(classes={Exception.class, ExceptionHandler.class})
public class JavaExceptionHandler
implements ExceptionHandler<Exception, HttpResponse<? extends Problem>> {
    private static final IgniteLogger LOG = Loggers.forClass(JavaExceptionHandler.class);

    public HttpResponse<? extends Problem> handle(HttpRequest request, Exception exception) {
        LOG.error("Unhandled exception", (Throwable)exception);
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.INTERNAL_ERROR).detail(exception.getMessage()));
    }
}

