/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.NullArgument;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UnresolvedArgument;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

abstract class AbstractRouteMatch<T, R>
implements MethodBasedRouteMatch<T, R> {
    protected final MethodExecutionHandle<T, R> executableMethod;
    protected final ConversionService<?> conversionService;
    protected final DefaultRouteBuilder.AbstractRoute abstractRoute;
    protected final List<MediaType> consumedMediaTypes;
    protected final List<MediaType> producedMediaTypes;

    protected AbstractRouteMatch(DefaultRouteBuilder.AbstractRoute abstractRoute, ConversionService<?> conversionService) {
        this.abstractRoute = abstractRoute;
        this.executableMethod = abstractRoute.targetMethod;
        this.conversionService = conversionService;
        this.consumedMediaTypes = abstractRoute.getConsumes();
        this.producedMediaTypes = abstractRoute.getProduces();
    }

    @Override
    public final boolean isSuspended() {
        return this.abstractRoute.isSuspended();
    }

    @Override
    public final boolean isReactive() {
        return this.abstractRoute.isReactive();
    }

    @Override
    public final boolean isSingleResult() {
        return this.abstractRoute.isSingleResult();
    }

    @Override
    public final boolean isSpecifiedSingle() {
        return this.abstractRoute.isSpecifiedSingle();
    }

    @Override
    public final boolean isAsync() {
        return this.abstractRoute.isAsync();
    }

    @Override
    public final boolean isVoid() {
        return this.abstractRoute.isVoid();
    }

    @Override
    public boolean isAsyncOrReactive() {
        return this.abstractRoute.isAsyncOrReactive();
    }

    public T getTarget() {
        return (T)this.executableMethod.getTarget();
    }

    @NonNull
    public ExecutableMethod<?, R> getExecutableMethod() {
        return this.executableMethod.getExecutableMethod();
    }

    @Override
    public List<MediaType> getProduces() {
        return this.abstractRoute.getProduces();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.executableMethod.getAnnotationMetadata();
    }

    @Override
    public Optional<Argument<?>> getBodyArgument() {
        Argument<?> arg = this.abstractRoute.bodyArgument;
        if (arg != null) {
            return Optional.of(arg);
        }
        String bodyArgument = this.abstractRoute.bodyArgumentName;
        if (bodyArgument != null) {
            return Optional.ofNullable(this.abstractRoute.requiredInputs.get(bodyArgument));
        }
        return Optional.empty();
    }

    @Override
    public boolean isRequiredInput(String name) {
        return this.abstractRoute.requiredInputs.containsKey(name);
    }

    @Override
    public Optional<Argument<?>> getRequiredInput(String name) {
        return Optional.ofNullable(this.abstractRoute.requiredInputs.get(name));
    }

    @Override
    public boolean isExecutable() {
        Map<String, Object> variables = this.getVariableValues();
        for (Map.Entry<String, Argument> entry : this.abstractRoute.requiredInputs.entrySet()) {
            Object value = variables.get(entry.getKey());
            if (value != null && !(value instanceof UnresolvedArgument)) continue;
            return false;
        }
        Optional<Argument<?>> bodyArgument = this.getBodyArgument();
        if (bodyArgument.isPresent()) {
            Object value = variables.get(bodyArgument.get().getName());
            return value != null && !(value instanceof UnresolvedArgument);
        }
        return true;
    }

    public Method getTargetMethod() {
        return this.executableMethod.getTargetMethod();
    }

    public String getMethodName() {
        return this.executableMethod.getMethodName();
    }

    @Override
    public Class getDeclaringType() {
        return this.executableMethod.getDeclaringType();
    }

    public Argument[] getArguments() {
        return this.executableMethod.getArguments();
    }

    @Override
    public boolean test(HttpRequest request) {
        for (Predicate<HttpRequest<?>> condition : this.abstractRoute.conditions) {
            if (condition.test(request)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReturnType<R> getReturnType() {
        return this.executableMethod.getReturnType();
    }

    public R invoke(Object ... arguments) {
        ConversionService<?> conversionService = this.conversionService;
        Argument[] targetArguments = this.getArguments();
        if (targetArguments.length == 0) {
            return (R)this.executableMethod.invoke(new Object[0]);
        }
        ArrayList argumentList = new ArrayList(arguments.length);
        Map<String, Object> variables = this.getVariableValues();
        Iterator<Object> valueIterator = variables.values().iterator();
        int i = 0;
        for (Argument targetArgument : targetArguments) {
            Optional result;
            String name = targetArgument.getName();
            Object value = variables.get(name);
            if (value != null) {
                result = conversionService.convert(value, targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + this.executableMethod)));
                continue;
            }
            if (valueIterator.hasNext()) {
                result = conversionService.convert(valueIterator.next(), targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + this.executableMethod)));
                continue;
            }
            if (i < arguments.length) {
                result = conversionService.convert(arguments[i++], targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + this.executableMethod)));
                continue;
            }
            throw new IllegalArgumentException("Wrong number of arguments to method: " + this.executableMethod);
        }
        return (R)this.executableMethod.invoke(argumentList.toArray());
    }

    @Override
    public R execute(Map<String, Object> argumentValues) {
        Argument[] targetArguments = this.getArguments();
        if (targetArguments.length == 0) {
            return (R)this.executableMethod.invoke(new Object[0]);
        }
        ConversionService<?> conversionService = this.conversionService;
        Map<String, Object> uriVariables = this.getVariableValues();
        ArrayList argumentList = new ArrayList(argumentValues.size());
        for (Map.Entry<String, Argument> entry : this.abstractRoute.requiredInputs.entrySet()) {
            Argument argument = entry.getValue();
            String name = entry.getKey();
            Object value = DefaultRouteBuilder.NO_VALUE;
            if (uriVariables.containsKey(name)) {
                value = uriVariables.get(name);
            } else if (argumentValues.containsKey(name)) {
                value = argumentValues.get(name);
            }
            Class argumentType = argument.getType();
            if (value instanceof UnresolvedArgument) {
                UnresolvedArgument unresolved = (UnresolvedArgument)value;
                ArgumentBinder.BindingResult bindingResult = (ArgumentBinder.BindingResult)unresolved.get();
                if (bindingResult.isPresentAndSatisfied()) {
                    Object resolved = bindingResult.get();
                    if (resolved instanceof ConversionError) {
                        ConversionError conversionError = (ConversionError)resolved;
                        throw new ConversionErrorException(argument, conversionError);
                    }
                    this.convertValueAndAddToList(conversionService, argumentList, argument, resolved, argumentType);
                    continue;
                }
                if (argument.isNullable()) {
                    argumentList.add(null);
                    continue;
                }
                List conversionErrors = bindingResult.getConversionErrors();
                if (!conversionErrors.isEmpty()) {
                    ConversionError conversionError = (ConversionError)conversionErrors.iterator().next();
                    throw new ConversionErrorException(argument, conversionError);
                }
                throw UnsatisfiedRouteException.create(argument);
            }
            if (value instanceof NullArgument) {
                argumentList.add(null);
                continue;
            }
            if (value instanceof ConversionError) {
                throw new ConversionErrorException(argument, (ConversionError)value);
            }
            if (value == DefaultRouteBuilder.NO_VALUE) {
                throw UnsatisfiedRouteException.create(argument);
            }
            this.convertValueAndAddToList(conversionService, argumentList, argument, value, argumentType);
        }
        return (R)this.executableMethod.invoke(argumentList.toArray());
    }

    private void convertValueAndAddToList(ConversionService conversionService, List argumentList, Argument argument, Object value, Class argumentType) {
        if (argumentType.isInstance(value)) {
            if (argument.isContainerType()) {
                if (argument.hasTypeVariables()) {
                    ArgumentConversionContext conversionContext = ConversionContext.of((Argument)argument);
                    Optional result = conversionService.convert(value, argumentType, (ConversionContext)conversionContext);
                    argumentList.add(this.resolveValueOrError(argument, (ConversionContext)conversionContext, result));
                } else {
                    argumentList.add(value);
                }
            } else {
                argumentList.add(value);
            }
        } else {
            ArgumentConversionContext conversionContext = ConversionContext.of((Argument)argument);
            Optional result = conversionService.convert(value, argumentType, (ConversionContext)conversionContext);
            argumentList.add(this.resolveValueOrError(argument, (ConversionContext)conversionContext, result));
        }
    }

    @Override
    public boolean doesConsume(MediaType contentType) {
        return contentType == null || this.abstractRoute.consumesMediaTypesContainsAll || this.explicitlyConsumes(contentType);
    }

    @Override
    public boolean doesProduce(@Nullable Collection<MediaType> acceptableTypes) {
        return this.abstractRoute.producesMediaTypesContainsAll || this.anyMediaTypesMatch(this.producedMediaTypes, acceptableTypes);
    }

    @Override
    public boolean doesProduce(@Nullable MediaType acceptableType) {
        return this.abstractRoute.producesMediaTypesContainsAll || acceptableType == null || acceptableType.equals((Object)MediaType.ALL_TYPE) || this.producedMediaTypes.contains(acceptableType);
    }

    private boolean anyMediaTypesMatch(List<MediaType> producedMediaTypes, Collection<MediaType> acceptableTypes) {
        if (CollectionUtils.isEmpty(acceptableTypes)) {
            return true;
        }
        for (MediaType acceptableType : acceptableTypes) {
            if (!acceptableType.equals((Object)MediaType.ALL_TYPE) && !producedMediaTypes.contains(acceptableType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean explicitlyConsumes(MediaType contentType) {
        return this.consumedMediaTypes.contains(contentType);
    }

    @Override
    public boolean explicitlyProduces(MediaType contentType) {
        return this.producedMediaTypes == null || this.producedMediaTypes.isEmpty() || this.producedMediaTypes.contains(contentType);
    }

    @Override
    public RouteMatch<R> fulfill(Map<String, Object> argumentValues) {
        if (CollectionUtils.isEmpty(argumentValues)) {
            return this;
        }
        Map<String, Object> oldVariables = this.getVariableValues();
        LinkedHashMap<String, Object> newVariables = new LinkedHashMap<String, Object>(oldVariables);
        Argument bodyArgument = this.getBodyArgument().orElse(null);
        Argument[] arguments = this.getArguments();
        Collection<Argument> requiredArguments = this.getRequiredArguments();
        boolean hasRequiredArguments = CollectionUtils.isNotEmpty(requiredArguments);
        for (Argument requiredArgument : arguments) {
            Object result;
            String argumentName = requiredArgument.getName();
            if (!argumentValues.containsKey(argumentName)) continue;
            Object value = argumentValues.get(argumentName);
            if (bodyArgument != null && bodyArgument.getName().equals(argumentName)) {
                requiredArgument = bodyArgument;
            }
            if (hasRequiredArguments) {
                requiredArguments.remove(requiredArgument);
            }
            if (value == null) continue;
            String name = this.abstractRoute.resolveInputName(requiredArgument);
            if (value instanceof UnresolvedArgument || value instanceof NullArgument) {
                newVariables.put(name, value);
                continue;
            }
            Class type = requiredArgument.getType();
            if (type.isInstance(value)) {
                newVariables.put(name, value);
                continue;
            }
            ArgumentConversionContext conversionContext = ConversionContext.of((Argument)requiredArgument);
            Optional converted = this.conversionService.convert(value, conversionContext);
            Object object = result = converted.isPresent() ? converted.get() : conversionContext.getLastError().orElse(null);
            if (result == null) continue;
            newVariables.put(name, result);
        }
        return this.newFulfilled(newVariables, (List)requiredArguments);
    }

    @Override
    public HttpStatus findStatus(HttpStatus defaultStatus) {
        return this.abstractRoute.definedStatus == null ? defaultStatus : this.abstractRoute.definedStatus;
    }

    @Override
    public boolean isWebSocketRoute() {
        return this.abstractRoute.isWebSocketRoute;
    }

    protected Object resolveValueOrError(Argument argument, ConversionContext conversionContext, Optional<?> result) {
        if (!result.isPresent()) {
            Optional lastError = conversionContext.getLastError();
            if (!lastError.isPresent() && argument.isDeclaredNullable()) {
                return null;
            }
            throw lastError.map(conversionError -> new ConversionErrorException(argument, conversionError)).orElseGet(() -> UnsatisfiedRouteException.create(argument));
        }
        return result.get();
    }

    protected abstract RouteMatch<R> newFulfilled(Map<String, Object> var1, List<Argument> var2);
}

