/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.direct.state;

import java.lang.reflect.Array;
import java.util.function.Supplier;
import org.apache.ignite.internal.network.direct.state.DirectMessageStateItem;

public class DirectMessageState<T extends DirectMessageStateItem> {
    private static final int INIT_SIZE = 10;
    private final Supplier<T> factory;
    private T[] stack;
    private int pos;

    public DirectMessageState(Class<T> cls, Supplier<T> factory) {
        this.factory = factory;
        this.stack = (DirectMessageStateItem[])Array.newInstance(cls, 10);
        this.stack[0] = (DirectMessageStateItem)factory.get();
    }

    public T item() {
        return this.stack[this.pos];
    }

    public void forward() {
        ++this.pos;
        if (this.pos == this.stack.length) {
            T[] stack0 = this.stack;
            this.stack = (DirectMessageStateItem[])Array.newInstance(this.stack.getClass().getComponentType(), this.stack.length << 1);
            System.arraycopy(stack0, 0, this.stack, 0, stack0.length);
        }
        if (this.stack[this.pos] == null) {
            this.stack[this.pos] = (DirectMessageStateItem)this.factory.get();
        }
    }

    public void backward(boolean reset) {
        if (reset) {
            this.stack[this.pos].reset();
        }
        --this.pos;
    }

    public void reset() {
        assert (this.pos == 0);
        this.stack[0].reset();
    }
}

