/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessage;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessageBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class QueryCloseMessageImpl
implements QueryCloseMessage {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 6;
    @IgniteToStringInclude
    private final UUID queryId;

    private QueryCloseMessageImpl(UUID queryId) {
        this.queryId = queryId;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(QueryCloseMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 6;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryCloseMessageImpl otherMessage = (QueryCloseMessageImpl)other;
        return Objects.equals(this.queryId, otherMessage.queryId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.queryId);
        return result;
    }

    public static QueryCloseMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements QueryCloseMessageBuilder {
        private UUID queryId;

        private Builder() {
        }

        @Override
        public QueryCloseMessageBuilder queryId(UUID queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public QueryCloseMessage build() {
            return new QueryCloseMessageImpl(this.queryId);
        }
    }
}

