/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.api.ColumnMetadataImpl;
import org.apache.ignite.internal.sql.api.ResultSetMetadataImpl;
import org.apache.ignite.internal.sql.engine.prepare.CacheKey;
import org.apache.ignite.internal.sql.engine.prepare.DdlPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainPlan;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.prepare.LazyResultSetMetadata;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepDmlPlan;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepQueryPlan;
import org.apache.ignite.internal.sql.engine.prepare.PlannerHelper;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.prepare.QueryTemplate;
import org.apache.ignite.internal.sql.engine.prepare.Splitter;
import org.apache.ignite.internal.sql.engine.prepare.ValidationResult;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DdlSqlToCommandConverter;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.schema.SchemaUpdateListener;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.BaseQueryContext;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class PrepareServiceImpl
implements PrepareService,
SchemaUpdateListener {
    private static final IgniteLogger LOG = Loggers.forClass(PrepareServiceImpl.class);
    private static final long THREAD_TIMEOUT_MS = 60000L;
    private static final int THREAD_COUNT = 4;
    private final DdlSqlToCommandConverter ddlConverter;
    private final ConcurrentMap<CacheKey, CompletableFuture<QueryPlan>> cache;
    private final String nodeName;
    private volatile ThreadPoolExecutor planningPool;

    public static PrepareServiceImpl create(String nodeName, int cacheSize, DataStorageManager dataStorageManager, Map<String, Map<String, Class<?>>> dataStorageFields) {
        return new PrepareServiceImpl(nodeName, cacheSize, new DdlSqlToCommandConverter(dataStorageFields, () -> ((DataStorageManager)dataStorageManager).defaultDataStorage()));
    }

    public PrepareServiceImpl(String nodeName, int cacheSize, DdlSqlToCommandConverter ddlConverter) {
        this.nodeName = nodeName;
        this.ddlConverter = ddlConverter;
        this.cache = Caffeine.newBuilder().maximumSize((long)cacheSize).build().asMap();
    }

    @Override
    public void start() {
        this.planningPool = new ThreadPoolExecutor(4, 4, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(NamedThreadFactory.threadPrefix((String)this.nodeName, (String)"sql-planning-pool"), LOG));
        this.planningPool.allowCoreThreadTimeOut(true);
    }

    @Override
    public void stop() throws Exception {
        this.planningPool.shutdownNow();
    }

    @Override
    public CompletableFuture<QueryPlan> prepareAsync(SqlNode sqlNode, BaseQueryContext ctx) {
        try {
            assert (this.single(sqlNode));
            PlanningContext planningContext = PlanningContext.builder().parentContext(ctx).build();
            if (SqlKind.DDL.contains(sqlNode.getKind())) {
                return this.prepareDdl(sqlNode, planningContext);
            }
            switch (sqlNode.getKind()) {
                case SELECT: 
                case ORDER_BY: 
                case WITH: 
                case VALUES: 
                case UNION: 
                case EXCEPT: 
                case INTERSECT: {
                    return this.prepareQuery(sqlNode, planningContext);
                }
                case INSERT: 
                case DELETE: 
                case UPDATE: 
                case MERGE: {
                    return this.prepareDml(sqlNode, planningContext);
                }
                case EXPLAIN: {
                    return this.prepareExplain(sqlNode, planningContext);
                }
            }
            throw new IgniteInternalException(ErrorGroups.Sql.USUPPORTED_SQL_OPERATION_KIND_ERR, "Unsupported operation [sqlNodeKind=" + sqlNode.getKind() + "; querySql=\"" + planningContext.query() + "\"]");
        }
        catch (CalciteContextException e) {
            throw new IgniteInternalException(ErrorGroups.Sql.QUERY_VALIDATION_ERR, "Failed to validate query. " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void onSchemaUpdated() {
        this.cache.clear();
    }

    private CompletableFuture<QueryPlan> prepareDdl(SqlNode sqlNode, PlanningContext ctx) {
        assert (sqlNode instanceof SqlDdl) : sqlNode == null ? "null" : sqlNode.getClass().getName();
        return CompletableFuture.completedFuture(new DdlPlan(this.ddlConverter.convert((SqlDdl)sqlNode, ctx)));
    }

    private CompletableFuture<QueryPlan> prepareExplain(SqlNode explain, PlanningContext ctx) {
        return CompletableFuture.supplyAsync(() -> {
            IgnitePlanner planner = ctx.planner();
            SqlNode sql = ((SqlExplain)explain).getExplicandum();
            sql = planner.validate(sql);
            IgniteRel igniteRel = PlannerHelper.optimize(sql, planner);
            String plan = RelOptUtil.toString((RelNode)igniteRel, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES);
            return new ExplainPlan(plan);
        }, this.planningPool);
    }

    private boolean single(SqlNode sqlNode) {
        return !(sqlNode instanceof SqlNodeList);
    }

    private CompletableFuture<QueryPlan> prepareQuery(SqlNode sqlNode, PlanningContext ctx) {
        boolean distributed = TraitUtils.distributionPresent((ImmutableList<RelTraitDef>)ctx.config().getTraitDefs());
        CacheKey key = new CacheKey(ctx.schemaName(), sqlNode.toString(), distributed);
        CompletableFuture planFut = this.cache.computeIfAbsent(key, k -> CompletableFuture.supplyAsync(() -> {
            IgnitePlanner planner = ctx.planner();
            ValidationResult validated = planner.validateAndGetTypeMetadata(sqlNode);
            SqlNode validatedNode = validated.sqlNode();
            IgniteRel igniteRel = PlannerHelper.optimize(validatedNode, planner);
            List<Fragment> fragments = new Splitter().go(igniteRel);
            QueryTemplate template = new QueryTemplate(fragments);
            return new MultiStepQueryPlan(template, this.resultSetMetadata(validated.dataType(), validated.origins()));
        }, this.planningPool));
        return planFut.thenApply(QueryPlan::copy);
    }

    private CompletableFuture<QueryPlan> prepareDml(SqlNode sqlNode, PlanningContext ctx) {
        CacheKey key = new CacheKey(ctx.schemaName(), sqlNode.toString());
        CompletableFuture planFut = this.cache.computeIfAbsent(key, k -> CompletableFuture.supplyAsync(() -> {
            IgnitePlanner planner = ctx.planner();
            SqlNode validatedNode = planner.validate(sqlNode);
            IgniteRel igniteRel = PlannerHelper.optimize(validatedNode, planner);
            List<Fragment> fragments = new Splitter().go(igniteRel);
            QueryTemplate template = new QueryTemplate(fragments);
            return new MultiStepDmlPlan(template);
        }, this.planningPool));
        return planFut.thenApply(QueryPlan::copy);
    }

    private ResultSetMetadata resultSetMetadata(RelDataType rowType, @Nullable List<List<String>> origins) {
        return new LazyResultSetMetadata(() -> {
            ArrayList<ColumnMetadata> fieldsMeta = new ArrayList<ColumnMetadata>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                RelDataTypeField fld = (RelDataTypeField)rowType.getFieldList().get(i);
                ColumnMetadataImpl fldMeta = new ColumnMetadataImpl(fld.getName(), TypeUtils.columnType(fld.getType()), fld.getType().getPrecision(), fld.getType().getScale(), fld.getType().isNullable(), origins == null ? null : ColumnMetadataImpl.originFromList((List)origins.get(i)));
                fieldsMeta.add(fldMeta);
            }
            return new ResultSetMetadataImpl(fieldsMeta);
        });
    }
}

