/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.index.ColumnCollation;
import org.apache.ignite.internal.index.Index;
import org.apache.ignite.internal.index.SortedIndex;
import org.apache.ignite.internal.index.SortedIndexDescriptor;
import org.jetbrains.annotations.Nullable;

public class IgniteIndex {
    private final List<String> columns;
    @Nullable
    private final List<Collation> collations;
    private final Index<?> index;
    private final Type type;

    public IgniteIndex(Index<?> index) {
        this.index = Objects.requireNonNull(index, "index");
        this.columns = index.descriptor().columns();
        this.collations = IgniteIndex.deriveCollations(index);
        this.type = index instanceof SortedIndex ? Type.SORTED : Type.HASH;
    }

    public List<String> columns() {
        return this.columns;
    }

    @Nullable
    public List<Collation> collations() {
        return this.collations;
    }

    public String name() {
        return this.index.name();
    }

    public Index<?> index() {
        return this.index;
    }

    public Type type() {
        return this.type;
    }

    @Nullable
    private static List<Collation> deriveCollations(Index<?> index) {
        if (index.descriptor() instanceof SortedIndexDescriptor) {
            SortedIndexDescriptor descriptor = (SortedIndexDescriptor)index.descriptor();
            ArrayList<Collation> orders = new ArrayList<Collation>(descriptor.columns().size());
            for (String column : descriptor.columns()) {
                ColumnCollation collation = descriptor.collation(column);
                assert (collation != null);
                orders.add(Collation.of(collation.asc(), collation.nullsFirst()));
            }
            return List.copyOf(orders);
        }
        return null;
    }

    public static enum Type {
        HASH,
        SORTED;

    }

    public static enum Collation {
        ASC_NULLS_FIRST(true, true),
        ASC_NULLS_LAST(true, false),
        DESC_NULLS_FIRST(false, true),
        DESC_NULLS_LAST(false, false);

        public final boolean asc;
        public final boolean nullsFirst;

        public static Collation of(boolean asc, boolean nullsFirst) {
            return asc ? (nullsFirst ? ASC_NULLS_FIRST : ASC_NULLS_LAST) : (nullsFirst ? DESC_NULLS_FIRST : DESC_NULLS_LAST);
        }

        private Collation(boolean asc, boolean nullsFirst) {
            this.asc = asc;
            this.nullsFirst = nullsFirst;
        }
    }
}

