/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.sql.engine.trait.DistributionFunction;
import org.apache.ignite.internal.sql.engine.trait.DistributionTrait;
import org.apache.ignite.internal.sql.engine.trait.DistributionTraitDef;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;

public class IgniteDistributions {
    private static final IgniteDistribution BROADCAST = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.broadcast()));
    private static final IgniteDistribution SINGLETON = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.singleton()));
    private static final IgniteDistribution RANDOM = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.random()));
    private static final IgniteDistribution ANY = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.any()));

    public static IgniteDistribution any() {
        return ANY;
    }

    public static IgniteDistribution random() {
        return RANDOM;
    }

    public static IgniteDistribution single() {
        return SINGLETON;
    }

    public static IgniteDistribution broadcast() {
        return BROADCAST;
    }

    public static IgniteDistribution affinity(int key, String cacheName, Object identity) {
        return IgniteDistributions.affinity(key, 0, identity);
    }

    public static IgniteDistribution affinity(int key, int cacheId, Object identity) {
        return IgniteDistributions.hash(ImmutableIntList.of((int[])new int[]{key}), DistributionFunction.affinity(cacheId, identity));
    }

    public static IgniteDistribution affinity(ImmutableIntList keys, int cacheId, Object identity) {
        return IgniteDistributions.hash(keys, DistributionFunction.affinity(cacheId, identity));
    }

    public static IgniteDistribution hash(List<Integer> keys) {
        return IgniteDistributions.canonize(new DistributionTrait(ImmutableIntList.copyOf(keys), DistributionFunction.hash()));
    }

    public static IgniteDistribution hash(ImmutableIntList keys, DistributionFunction function) {
        return IgniteDistributions.canonize(new DistributionTrait(keys, function));
    }

    private static IgniteDistribution canonize(IgniteDistribution distr) {
        return (IgniteDistribution)DistributionTraitDef.INSTANCE.canonize((RelTrait)distr);
    }
}

