/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLog;
import io.micronaut.http.server.netty.handler.accesslog.element.ConstantElement;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElementBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogFormatParser {
    public static final String COMBINED_LOG_FORMAT = "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"";
    public static final String COMMON_LOG_FORMAT = "%h %l %u %t \"%r\" %s %b";
    private static final List<LogElementBuilder> LOG_ELEMENT_BUILDERS;
    private static final Logger LOGGER;
    private final List<IndexedLogElement> onRequestElements = new ArrayList<IndexedLogElement>();
    private final List<IndexedLogElement> onResponseHeadersElements = new ArrayList<IndexedLogElement>();
    private final List<IndexedLogElement> onResponseWriteElements = new ArrayList<IndexedLogElement>();
    private final List<IndexedLogElement> onLastResponseWriteElements = new ArrayList<IndexedLogElement>();
    private final List<IndexedLogElement> constantElements = new ArrayList<IndexedLogElement>();
    private String[] elements;

    public AccessLogFormatParser(String spec) {
        this.parse(spec);
    }

    public AccessLog newAccessLogger() {
        String[] newElements = new String[this.elements.length];
        System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
        IdentityHashMap<IndexedLogElement, IndexedLogElement> map = new IdentityHashMap<IndexedLogElement, IndexedLogElement>();
        return new AccessLog(AccessLogFormatParser.copy(map, this.onRequestElements), AccessLogFormatParser.copy(map, this.onResponseHeadersElements), AccessLogFormatParser.copy(map, this.onResponseWriteElements), AccessLogFormatParser.copy(map, this.onLastResponseWriteElements), newElements);
    }

    public String toString() {
        TreeSet<IndexedLogElement> elts = new TreeSet<IndexedLogElement>();
        elts.addAll(this.constantElements);
        elts.addAll(this.onLastResponseWriteElements);
        elts.addAll(this.onRequestElements);
        elts.addAll(this.onResponseHeadersElements);
        elts.addAll(this.onResponseWriteElements);
        return elts.stream().map(IndexedLogElement::toString).collect(Collectors.joining());
    }

    private static List<IndexedLogElement> copy(Map<IndexedLogElement, IndexedLogElement> map, List<IndexedLogElement> l) {
        return l.stream().map(elt -> map.computeIfAbsent((IndexedLogElement)elt, IndexedLogElement::copyIndexedLogElement)).collect(Collectors.toList());
    }

    private void parse(String spec) {
        if (spec == null || spec.isEmpty() || "common".equals(spec)) {
            spec = COMMON_LOG_FORMAT;
        } else if ("combined".equals(spec)) {
            spec = COMBINED_LOG_FORMAT;
        }
        List<LogElement> logElements = this.tokenize(spec);
        this.elements = new String[logElements.size()];
        for (int i = 0; i < this.elements.length; ++i) {
            LogElement element = logElements.get(i);
            IndexedLogElement indexedLogElement = new IndexedLogElement(element, i);
            if (element.events().isEmpty()) {
                this.constantElements.add(indexedLogElement);
                this.elements[i] = element.onRequestHeaders(null, null, null, null, null);
                continue;
            }
            if (element.events().contains((Object)LogElement.Event.ON_LAST_RESPONSE_WRITE)) {
                this.onLastResponseWriteElements.add(indexedLogElement);
            }
            if (element.events().contains((Object)LogElement.Event.ON_REQUEST_HEADERS)) {
                this.onRequestElements.add(indexedLogElement);
            }
            if (element.events().contains((Object)LogElement.Event.ON_RESPONSE_HEADERS)) {
                this.onResponseHeadersElements.add(indexedLogElement);
            }
            if (!element.events().contains((Object)LogElement.Event.ON_RESPONSE_WRITE)) continue;
            this.onResponseWriteElements.add(indexedLogElement);
        }
        AccessLogFormatParser.trimToSize(this.onLastResponseWriteElements);
        AccessLogFormatParser.trimToSize(this.onRequestElements);
        AccessLogFormatParser.trimToSize(this.onResponseHeadersElements);
        AccessLogFormatParser.trimToSize(this.onResponseWriteElements);
        AccessLogFormatParser.trimToSize(this.constantElements);
    }

    private static <T> void trimToSize(List<T> l) {
        ((ArrayList)l).trimToSize();
    }

    private List<LogElement> tokenize(String spec) {
        ArrayList<LogElement> logElements = new ArrayList<LogElement>();
        spec = spec.trim();
        int state = 0;
        StringBuilder token = new StringBuilder(40);
        for (int i = 0; i < spec.length(); ++i) {
            char c = spec.charAt(i);
            state = this.nextState(logElements, state, token, c);
        }
        if (state != 0 || logElements.isEmpty()) {
            LOGGER.warn("Invalid access log format: {}", (Object)spec);
            throw new IllegalArgumentException("Invalid access log format: " + spec);
        }
        this.checkConstantElement(logElements, token);
        return logElements;
    }

    private int nextState(List<LogElement> logElements, int state, StringBuilder token, char c) {
        switch (state) {
            case 0: {
                if (c == '%') {
                    state = 1;
                    break;
                }
                token.append(c);
                break;
            }
            case 1: {
                if (c == '{') {
                    this.checkConstantElement(logElements, token);
                    state = 2;
                    break;
                }
                if (c == '%') {
                    token.append(c);
                    state = 0;
                    break;
                }
                this.checkConstantElement(logElements, token);
                logElements.add(this.fromToken(Character.toString(c), null));
                state = 0;
                break;
            }
            case 2: {
                if (c == '}') {
                    state = 3;
                    break;
                }
                token.append(c);
                break;
            }
            case 3: {
                String param = token.toString();
                logElements.add(this.fromToken(Character.toString(c), param));
                token.setLength(0);
                state = 0;
                break;
            }
        }
        return state;
    }

    private void checkConstantElement(List<LogElement> logElements, StringBuilder token) {
        if (token.length() != 0) {
            logElements.add(new ConstantElement(token.toString()));
            token.setLength(0);
        }
    }

    private LogElement fromToken(String pattern, String param) {
        for (LogElementBuilder builder : LOG_ELEMENT_BUILDERS) {
            LogElement logElement = builder.build(pattern, param);
            if (logElement == null) continue;
            return logElement;
        }
        LOGGER.warn("Unknown access log marker: %{}", (Object)pattern);
        return ConstantElement.UNKNOWN;
    }

    static {
        LOGGER = LoggerFactory.getLogger(AccessLogFormatParser.class);
        SoftServiceLoader builders = SoftServiceLoader.load(LogElementBuilder.class, (ClassLoader)LogElementBuilder.class.getClassLoader());
        LOG_ELEMENT_BUILDERS = new ArrayList<LogElementBuilder>();
        for (ServiceDefinition definition : builders) {
            if (!definition.isPresent()) continue;
            LOG_ELEMENT_BUILDERS.add((LogElementBuilder)definition.load());
        }
        OrderUtil.sort(LOG_ELEMENT_BUILDERS);
        AccessLogFormatParser.trimToSize(LOG_ELEMENT_BUILDERS);
    }

    static class IndexedLogElement
    implements LogElement,
    Comparable<IndexedLogElement> {
        final int index;
        private final LogElement delegate;

        IndexedLogElement(LogElement delegate, int index) {
            this.delegate = delegate;
            this.index = index;
        }

        @Override
        public Set<LogElement.Event> events() {
            return this.delegate.events();
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public String onRequestHeaders(SocketChannel channel, String method, HttpHeaders headers, String uri, String protocol) {
            return this.delegate.onRequestHeaders(channel, method, headers, uri, protocol);
        }

        @Override
        public String onResponseHeaders(ChannelHandlerContext ctx, HttpHeaders headers, String status) {
            return this.delegate.onResponseHeaders(ctx, headers, status);
        }

        @Override
        public void onResponseWrite(int contentSize) {
            this.delegate.onResponseWrite(contentSize);
        }

        @Override
        public String onLastResponseWrite(int contentSize) {
            return this.delegate.onLastResponseWrite(contentSize);
        }

        @Override
        public LogElement copy() {
            return new IndexedLogElement(this.delegate.copy(), this.index);
        }

        public IndexedLogElement copyIndexedLogElement() {
            return new IndexedLogElement(this.delegate.copy(), this.index);
        }

        @Override
        public int compareTo(IndexedLogElement o) {
            return Long.compare(this.index, o.index);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexedLogElement other = (IndexedLogElement)obj;
            return this.index == other.index;
        }
    }
}

