/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Period;
import java.util.List;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;

class ClientSqlCommon {
    ClientSqlCommon() {
    }

    static void packCurrentPage(ClientMessagePacker out, AsyncResultSet asyncResultSet) {
        ResultSetMetadata meta = asyncResultSet.metadata();
        assert (meta != null) : "Metadata can't be null when row set is present.";
        List cols = meta.columns();
        out.packArrayHeader(asyncResultSet.currentPageSize());
        for (SqlRow row : asyncResultSet.currentPage()) {
            BinaryTupleBuilder builder = new BinaryTupleBuilder(row.columnCount(), true);
            for (int i = 0; i < cols.size(); ++i) {
                ClientSqlCommon.packValue(builder, (ColumnMetadata)cols.get(i), row, i);
            }
            out.packBinaryTuple(builder);
        }
        if (!asyncResultSet.hasMorePages()) {
            asyncResultSet.closeAsync();
        }
    }

    private static void packValue(BinaryTupleBuilder out, ColumnMetadata col, SqlRow row, int idx) {
        if (row.value(idx) == null) {
            out.appendNull();
            return;
        }
        switch (col.type()) {
            case BOOLEAN: {
                out.appendByte((Boolean)row.value(idx) != false ? (byte)1 : 0);
                break;
            }
            case INT8: {
                out.appendByte(row.byteValue(idx));
                break;
            }
            case INT16: {
                out.appendShort(row.shortValue(idx));
                break;
            }
            case INT32: {
                out.appendInt(row.intValue(idx));
                break;
            }
            case INT64: {
                out.appendLong(row.longValue(idx));
                break;
            }
            case FLOAT: {
                out.appendFloat(row.floatValue(idx));
                break;
            }
            case DOUBLE: {
                out.appendDouble(row.doubleValue(idx));
                break;
            }
            case DECIMAL: {
                out.appendDecimal((BigDecimal)row.value(idx), col.scale());
                break;
            }
            case DATE: {
                out.appendDate(row.dateValue(idx));
                break;
            }
            case TIME: {
                out.appendTime(row.timeValue(idx));
                break;
            }
            case DATETIME: {
                out.appendDateTime(row.datetimeValue(idx));
                break;
            }
            case TIMESTAMP: {
                out.appendTimestamp(row.timestampValue(idx));
                break;
            }
            case UUID: {
                out.appendUuid(row.uuidValue(idx));
                break;
            }
            case BITMASK: {
                out.appendBitmask(row.bitmaskValue(idx));
                break;
            }
            case STRING: {
                out.appendString(row.stringValue(idx));
                break;
            }
            case BYTE_ARRAY: {
                out.appendBytes((byte[])row.value(idx));
                break;
            }
            case PERIOD: {
                out.appendPeriod((Period)row.value(idx));
                break;
            }
            case DURATION: {
                out.appendDuration((Duration)row.value(idx));
                break;
            }
            case NUMBER: {
                out.appendNumber((BigInteger)row.value(idx));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported column type: " + col.type());
            }
        }
    }
}

