/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Grouping;
import org.apache.calcite.linq4j.Linq4j;
import org.checkerframework.checker.nullness.qual.Nullable;

class GroupingImpl<K, V>
extends AbstractEnumerable<V>
implements Grouping<K, V>,
Map.Entry<K, Enumerable<V>> {
    private final K key;
    private final List<V> values;

    GroupingImpl(K key, List<V> values) {
        this.key = Objects.requireNonNull(key, "key");
        this.values = Objects.requireNonNull(values, "values");
    }

    public String toString() {
        return this.key + ": " + this.values;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode() ^ this.values.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj instanceof GroupingImpl && this.key.equals(((GroupingImpl)obj).key) && this.values.equals(((GroupingImpl)obj).values);
    }

    @Override
    public Enumerable<V> getValue() {
        return Linq4j.asEnumerable(this.values);
    }

    @Override
    public Enumerable<V> setValue(Enumerable<V> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public Enumerator<V> enumerator() {
        return Linq4j.enumerator(this.values);
    }
}

