/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.pagememory.util.PageLockListenerNoOp;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.ByteBufferRow;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.schema.configuration.TablesView;
import org.apache.ignite.internal.schema.configuration.index.HashIndexView;
import org.apache.ignite.internal.schema.configuration.index.SortedIndexView;
import org.apache.ignite.internal.schema.configuration.index.TableIndexView;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.TxIdMismatchException;
import org.apache.ignite.internal.storage.index.HashIndexDescriptor;
import org.apache.ignite.internal.storage.index.SortedIndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumnsFreeList;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexTree;
import org.apache.ignite.internal.storage.pagememory.index.hash.PageMemoryHashIndexStorage;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMeta;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.index.sorted.PageMemorySortedIndexStorage;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexTree;
import org.apache.ignite.internal.storage.pagememory.mv.ReadRowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersionFreeList;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainKey;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.CursorUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPageMemoryMvPartitionStorage
implements MvPartitionStorage {
    private static final byte[] TOMBSTONE_PAYLOAD = new byte[0];
    private static final Predicate<HybridTimestamp> ALWAYS_LOAD_VALUE = timestamp -> true;
    protected final int partitionId;
    protected final int groupId;
    protected final AbstractPageMemoryTableStorage tableStorage;
    protected final VersionChainTree versionChainTree;
    protected final RowVersionFreeList rowVersionFreeList;
    protected final IndexColumnsFreeList indexFreeList;
    protected final IndexMetaTree indexMetaTree;
    private final TablesConfiguration tablesConfiguration;
    protected final DataPageReader rowVersionDataPageReader;
    protected final ConcurrentMap<UUID, PageMemoryHashIndexStorage> hashIndexes = new ConcurrentHashMap<UUID, PageMemoryHashIndexStorage>();
    protected final ConcurrentMap<UUID, PageMemorySortedIndexStorage> sortedIndexes = new ConcurrentHashMap<UUID, PageMemorySortedIndexStorage>();

    protected AbstractPageMemoryMvPartitionStorage(int partitionId, AbstractPageMemoryTableStorage tableStorage, RowVersionFreeList rowVersionFreeList, IndexColumnsFreeList indexFreeList, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, TablesConfiguration tablesCfg) {
        this.partitionId = partitionId;
        this.tableStorage = tableStorage;
        this.rowVersionFreeList = rowVersionFreeList;
        this.indexFreeList = indexFreeList;
        this.versionChainTree = versionChainTree;
        this.indexMetaTree = indexMetaTree;
        this.tablesConfiguration = tablesCfg;
        PageMemory pageMemory = tableStorage.dataRegion().pageMemory();
        this.groupId = ((TableView)tableStorage.configuration().value()).tableId();
        this.rowVersionDataPageReader = new DataPageReader(pageMemory, this.groupId, (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
    }

    public void start() {
        try (Cursor cursor = this.indexMetaTree.find(null, null);){
            NamedListView indexesCfgView = (NamedListView)this.tablesConfiguration.indexes().value();
            while (cursor.hasNext()) {
                IndexMeta indexMeta = (IndexMeta)cursor.next();
                TableIndexView indexCfgView = (TableIndexView)ConfigurationUtil.getByInternalId((NamedListView)indexesCfgView, (UUID)indexMeta.id());
                if (indexCfgView instanceof HashIndexView) {
                    this.createOrRestoreHashIndex(indexMeta);
                    continue;
                }
                if (indexCfgView instanceof SortedIndexView) {
                    this.createOrRestoreSortedIndex(indexMeta);
                    continue;
                }
                assert (indexCfgView == null);
            }
        }
        catch (Exception e) {
            throw new StorageException("Failed to process SQL indexes during the partition start", (Throwable)e);
        }
    }

    public PageMemoryHashIndexStorage getOrCreateHashIndex(UUID indexId) {
        return this.hashIndexes.computeIfAbsent(indexId, uuid -> this.createOrRestoreHashIndex(new IndexMeta(indexId, 0L)));
    }

    public PageMemorySortedIndexStorage getOrCreateSortedIndex(UUID indexId) {
        return this.sortedIndexes.computeIfAbsent(indexId, uuid -> this.createOrRestoreSortedIndex(new IndexMeta(indexId, 0L)));
    }

    private PageMemoryHashIndexStorage createOrRestoreHashIndex(IndexMeta indexMeta) {
        HashIndexDescriptor indexDescriptor = new HashIndexDescriptor(indexMeta.id(), (TablesView)this.tablesConfiguration.value());
        try {
            PageMemory pageMemory = this.tableStorage.dataRegion().pageMemory();
            boolean initNew = indexMeta.metaPageId() == 0L;
            long metaPageId = initNew ? pageMemory.allocatePage(this.groupId, this.partitionId, (byte)2) : indexMeta.metaPageId();
            String tableName = ((TableView)this.tableStorage.configuration().value()).name();
            HashIndexTree hashIndexTree = new HashIndexTree(this.groupId, tableName, this.partitionId, pageMemory, (PageLockListener)PageLockListenerNoOp.INSTANCE, new AtomicLong(), metaPageId, (ReuseList)this.rowVersionFreeList, indexDescriptor, initNew);
            if (initNew) {
                boolean replaced = this.indexMetaTree.putx(new IndexMeta(indexMeta.id(), metaPageId));
                assert (!replaced);
            }
            return new PageMemoryHashIndexStorage(indexDescriptor, this.indexFreeList, hashIndexTree);
        }
        catch (IgniteInternalCheckedException e) {
            throw new RuntimeException(e);
        }
    }

    private PageMemorySortedIndexStorage createOrRestoreSortedIndex(IndexMeta indexMeta) {
        SortedIndexDescriptor indexDescriptor = new SortedIndexDescriptor(indexMeta.id(), (TablesView)this.tablesConfiguration.value());
        try {
            PageMemory pageMemory = this.tableStorage.dataRegion().pageMemory();
            boolean initNew = indexMeta.metaPageId() == 0L;
            long metaPageId = initNew ? pageMemory.allocatePage(this.groupId, this.partitionId, (byte)2) : indexMeta.metaPageId();
            String tableName = ((TableView)this.tableStorage.configuration().value()).name();
            SortedIndexTree sortedIndexTree = new SortedIndexTree(this.groupId, tableName, this.partitionId, pageMemory, (PageLockListener)PageLockListenerNoOp.INSTANCE, new AtomicLong(), metaPageId, (ReuseList)this.rowVersionFreeList, indexDescriptor, initNew);
            if (initNew) {
                boolean replaced = this.indexMetaTree.putx(new IndexMeta(indexMeta.id(), metaPageId));
                assert (!replaced);
            }
            return new PageMemorySortedIndexStorage(indexDescriptor, this.indexFreeList, sortedIndexTree);
        }
        catch (IgniteInternalCheckedException e) {
            throw new RuntimeException(e);
        }
    }

    public ReadResult read(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        if (rowId.partitionId() != this.partitionId) {
            throw new IllegalArgumentException(String.format("RowId partition [%d] is not equal to storage partition [%d].", rowId.partitionId(), this.partitionId));
        }
        VersionChain versionChain = this.findVersionChain(rowId);
        if (versionChain == null) {
            return ReadResult.EMPTY;
        }
        if (this.lookingForLatestVersion(timestamp)) {
            return this.findLatestRowVersion(versionChain);
        }
        return this.findRowVersionByTimestamp(versionChain, timestamp);
    }

    private boolean lookingForLatestVersion(HybridTimestamp timestamp) {
        return timestamp == HybridTimestamp.MAX_VALUE;
    }

    @Nullable
    private VersionChain findVersionChain(RowId rowId) {
        try {
            return (VersionChain)this.versionChainTree.findOne(new VersionChainKey(rowId));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Version chain lookup failed", (Throwable)e);
        }
    }

    private ReadResult findLatestRowVersion(VersionChain versionChain) {
        RowVersion rowVersion = this.readRowVersion(versionChain.headLink(), ALWAYS_LOAD_VALUE);
        if (versionChain.isUncommitted()) {
            assert (versionChain.transactionId() != null);
            HybridTimestamp newestCommitTs = null;
            if (versionChain.hasCommittedVersions()) {
                long newestCommitLink = versionChain.newestCommittedLink();
                newestCommitTs = this.readRowVersion(newestCommitLink, ALWAYS_LOAD_VALUE).timestamp();
            }
            return this.writeIntentToResult(versionChain, rowVersion, newestCommitTs);
        }
        ByteBufferRow row = this.rowVersionToBinaryRow(rowVersion);
        return ReadResult.createFromCommitted((BinaryRow)row, (HybridTimestamp)rowVersion.timestamp());
    }

    private RowVersion readRowVersion(long nextLink, Predicate<HybridTimestamp> loadValue) {
        ReadRowVersion read = new ReadRowVersion(this.partitionId);
        try {
            this.rowVersionDataPageReader.traverse(nextLink, (PageMemoryTraversal)read, loadValue);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Row version lookup failed");
        }
        return read.result();
    }

    private void throwIfChainBelongsToAnotherTx(VersionChain versionChain, UUID txId) {
        assert (versionChain.isUncommitted());
        if (!txId.equals(versionChain.transactionId())) {
            throw new TxIdMismatchException(txId, versionChain.transactionId());
        }
    }

    @Nullable
    private ByteBufferRow rowVersionToBinaryRow(RowVersion rowVersion) {
        if (rowVersion.isTombstone()) {
            return null;
        }
        return new ByteBufferRow(rowVersion.value());
    }

    private ReadResult findRowVersionByTimestamp(VersionChain versionChain, HybridTimestamp timestamp) {
        assert (timestamp != null);
        long headLink = versionChain.headLink();
        if (versionChain.isUncommitted() && !versionChain.hasCommittedVersions()) {
            RowVersion rowVersion = this.readRowVersion(headLink, ALWAYS_LOAD_VALUE);
            return this.writeIntentToResult(versionChain, rowVersion, null);
        }
        return this.walkVersionChain(versionChain, timestamp);
    }

    private ReadResult walkVersionChain(VersionChain chainHead, HybridTimestamp timestamp) {
        assert (chainHead.hasCommittedVersions());
        boolean hasWriteIntent = chainHead.isUncommitted();
        RowVersion firstCommit = hasWriteIntent ? this.readRowVersion(chainHead.nextLink(), rowTimestamp -> timestamp.compareTo(rowTimestamp) == 0) : this.readRowVersion(chainHead.headLink(), rowTimestamp -> timestamp.compareTo(rowTimestamp) >= 0);
        assert (firstCommit.isCommitted());
        assert (firstCommit.timestamp() != null);
        if (hasWriteIntent && timestamp.compareTo(firstCommit.timestamp()) > 0) {
            RowVersion rowVersion = this.readRowVersion(chainHead.headLink(), ALWAYS_LOAD_VALUE);
            return this.writeIntentToResult(chainHead, rowVersion, firstCommit.timestamp());
        }
        RowVersion curCommit = firstCommit;
        do {
            assert (curCommit.timestamp() != null);
            int compareResult = timestamp.compareTo(curCommit.timestamp());
            if (compareResult < 0) continue;
            ByteBufferRow row = curCommit.isTombstone() ? null : new ByteBufferRow(curCommit.value());
            return ReadResult.createFromCommitted((BinaryRow)row, (HybridTimestamp)curCommit.timestamp());
        } while ((curCommit = !curCommit.hasNextLink() ? null : this.readRowVersion(curCommit.nextLink(), rowTimestamp -> timestamp.compareTo(rowTimestamp) >= 0)) != null);
        return ReadResult.EMPTY;
    }

    private ReadResult writeIntentToResult(VersionChain chain, RowVersion rowVersion, @Nullable HybridTimestamp lastCommittedTimestamp) {
        assert (rowVersion.isUncommitted());
        UUID transactionId = chain.transactionId();
        UUID commitTableId = chain.commitTableId();
        int commitPartitionId = chain.commitPartitionId();
        ByteBufferRow row = this.rowVersionToBinaryRow(rowVersion);
        return ReadResult.createFromWriteIntent((BinaryRow)row, (UUID)transactionId, (UUID)commitTableId, (int)commitPartitionId, (HybridTimestamp)lastCommittedTimestamp);
    }

    private RowVersion insertRowVersion(@Nullable BinaryRow row, long nextPartitionlessLink) {
        byte[] rowBytes = AbstractPageMemoryMvPartitionStorage.rowBytes(row);
        RowVersion rowVersion = new RowVersion(this.partitionId, nextPartitionlessLink, ByteBuffer.wrap(rowBytes));
        this.insertRowVersion(rowVersion);
        return rowVersion;
    }

    private void insertRowVersion(RowVersion rowVersion) {
        try {
            this.rowVersionFreeList.insertDataRow(rowVersion);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot store a row version", (Throwable)e);
        }
    }

    private static byte[] rowBytes(@Nullable BinaryRow row) {
        return row == null ? TOMBSTONE_PAYLOAD : row.bytes();
    }

    @Nullable
    public BinaryRow addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, UUID commitTableId, int commitPartitionId) throws TxIdMismatchException, StorageException {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        VersionChain currentChain = this.findVersionChain(rowId);
        if (currentChain == null) {
            RowVersion newVersion = this.insertRowVersion(row, 0L);
            VersionChain versionChain = VersionChain.createUncommitted(rowId, txId, commitTableId, commitPartitionId, newVersion.link(), 0L);
            this.updateVersionChain(versionChain);
            return null;
        }
        if (currentChain.isUncommitted()) {
            this.throwIfChainBelongsToAnotherTx(currentChain, txId);
        }
        RowVersion newVersion = this.insertRowVersion(row, currentChain.newestCommittedLink());
        ByteBufferRow res = null;
        if (currentChain.isUncommitted()) {
            RowVersion currentVersion = this.readRowVersion(currentChain.headLink(), ALWAYS_LOAD_VALUE);
            res = this.rowVersionToBinaryRow(currentVersion);
            this.removeRowVersion(currentVersion);
        }
        VersionChain chainReplacement = VersionChain.createUncommitted(rowId, txId, commitTableId, commitPartitionId, newVersion.link(), newVersion.nextLink());
        this.updateVersionChain(chainReplacement);
        return res;
    }

    @Nullable
    public BinaryRow abortWrite(RowId rowId) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        VersionChain currentVersionChain = this.findVersionChain(rowId);
        if (currentVersionChain == null || currentVersionChain.transactionId() == null) {
            return null;
        }
        RowVersion latestVersion = this.readRowVersion(currentVersionChain.headLink(), ALWAYS_LOAD_VALUE);
        assert (latestVersion.isUncommitted());
        this.removeRowVersion(latestVersion);
        if (latestVersion.hasNextLink()) {
            VersionChain versionChainReplacement = VersionChain.createCommitted(rowId, latestVersion.nextLink(), 0L);
            this.updateVersionChain(versionChainReplacement);
        } else {
            this.removeVersionChain(currentVersionChain);
        }
        return this.rowVersionToBinaryRow(latestVersion);
    }

    private void removeVersionChain(VersionChain currentVersionChain) {
        try {
            this.versionChainTree.remove(currentVersionChain);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot remove chain version", (Throwable)e);
        }
    }

    public void commitWrite(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        VersionChain currentVersionChain = this.findVersionChain(rowId);
        if (currentVersionChain == null || currentVersionChain.transactionId() == null) {
            return;
        }
        long chainLink = currentVersionChain.headLink();
        try {
            this.rowVersionFreeList.updateTimestamp(chainLink, timestamp);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot update timestamp", (Throwable)e);
        }
        try {
            VersionChain updatedVersionChain = VersionChain.createCommitted(currentVersionChain.rowId(), currentVersionChain.headLink(), currentVersionChain.nextLink());
            this.versionChainTree.putx(updatedVersionChain);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot update transaction ID", (Throwable)e);
        }
    }

    private void removeRowVersion(RowVersion currentVersion) {
        try {
            this.rowVersionFreeList.removeDataRowByLink(currentVersion.link());
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot update row version", (Throwable)e);
        }
    }

    private void updateVersionChain(VersionChain newVersionChain) {
        try {
            this.versionChainTree.putx(newVersionChain);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot update version chain");
        }
    }

    public void addWriteCommitted(RowId rowId, BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : rowId;
        VersionChain currentChain = this.findVersionChain(rowId);
        if (currentChain != null && currentChain.isUncommitted()) {
            throw new StorageException("Write intent exists for " + rowId);
        }
        long nextLink = currentChain == null ? 0L : currentChain.newestCommittedLink();
        RowVersion newVersion = this.insertCommittedRowVersion(row, commitTimestamp, nextLink);
        VersionChain chainReplacement = VersionChain.createCommitted(rowId, newVersion.link(), newVersion.nextLink());
        this.updateVersionChain(chainReplacement);
    }

    private RowVersion insertCommittedRowVersion(BinaryRow row, HybridTimestamp commitTimestamp, long nextPartitionlessLink) {
        byte[] rowBytes = AbstractPageMemoryMvPartitionStorage.rowBytes(row);
        RowVersion rowVersion = new RowVersion(this.partitionId, commitTimestamp, nextPartitionlessLink, ByteBuffer.wrap(rowBytes));
        this.insertRowVersion(rowVersion);
        return rowVersion;
    }

    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        try {
            VersionChain versionChain = (VersionChain)this.versionChainTree.findOne(new VersionChainKey(rowId));
            if (versionChain == null) {
                return CursorUtils.emptyCursor();
            }
            RowVersion head = this.readRowVersion(versionChain.headLink(), ALWAYS_LOAD_VALUE);
            Stream<RowVersion> stream = Stream.iterate(head, Objects::nonNull, rowVersion -> rowVersion.nextLink() == 0L ? null : this.readRowVersion(rowVersion.nextLink(), ALWAYS_LOAD_VALUE));
            return Cursor.fromIterator(stream.map(rowVersion -> AbstractPageMemoryMvPartitionStorage.rowVersionToResultNotFillingLastCommittedTs(versionChain, rowVersion)).iterator());
        }
        catch (IgniteInternalCheckedException e) {
            throw new RuntimeException(e);
        }
    }

    private static ReadResult rowVersionToResultNotFillingLastCommittedTs(VersionChain versionChain, RowVersion rowVersion) {
        ByteBufferRow row = new ByteBufferRow(rowVersion.value());
        if (rowVersion.isCommitted()) {
            return ReadResult.createFromCommitted((BinaryRow)row, (HybridTimestamp)rowVersion.timestamp());
        }
        return ReadResult.createFromWriteIntent((BinaryRow)row, (UUID)versionChain.transactionId(), (UUID)versionChain.commitTableId(), (int)versionChain.commitPartitionId(), null);
    }

    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        Cursor treeCursor;
        Objects.requireNonNull(timestamp, "timestamp is null");
        try {
            treeCursor = this.versionChainTree.find(null, null);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Find failed", (Throwable)e);
        }
        if (this.lookingForLatestVersion(timestamp)) {
            return new LatestVersionsCursor((Cursor<VersionChain>)treeCursor);
        }
        return new TimestampCursor((Cursor<VersionChain>)treeCursor, timestamp);
    }

    @Nullable
    public RowId closestRowId(RowId lowerBound) throws StorageException {
        RowId rowId;
        block8: {
            Cursor cursor = this.versionChainTree.find(new VersionChainKey(lowerBound), null);
            try {
                RowId rowId2 = rowId = cursor.hasNext() ? ((VersionChain)cursor.next()).rowId() : null;
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException("Error occurred while trying to read a row id", (Throwable)e);
                }
            }
            cursor.close();
        }
        return rowId;
    }

    public long rowsCount() {
        try {
            return this.versionChainTree.size();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error occurred while fetching the size.", (Throwable)e);
        }
    }

    public void forEach(BiConsumer<RowId, BinaryRow> consumer) {
    }

    public void close() {
        this.versionChainTree.close();
        this.indexMetaTree.close();
    }

    public void destroy() {
    }

    private class LatestVersionsCursor
    extends BasePartitionTimestampCursor {
        private boolean iterationExhausted;

        public LatestVersionsCursor(Cursor<VersionChain> treeCursor) {
            super(treeCursor);
            this.iterationExhausted = false;
        }

        public boolean hasNext() {
            VersionChain chain;
            ReadResult result;
            if (this.nextRead != null) {
                return true;
            }
            if (this.iterationExhausted) {
                return false;
            }
            do {
                if (this.treeCursor.hasNext()) continue;
                this.iterationExhausted = true;
                return false;
            } while ((result = AbstractPageMemoryMvPartitionStorage.this.findLatestRowVersion(chain = (VersionChain)this.treeCursor.next())).isEmpty() && !result.isWriteIntent());
            this.nextRead = result;
            this.currentChain = chain;
            return true;
        }
    }

    private class TimestampCursor
    extends BasePartitionTimestampCursor {
        private final HybridTimestamp timestamp;
        private boolean iterationExhausted;

        public TimestampCursor(Cursor<VersionChain> treeCursor, HybridTimestamp timestamp) {
            super(treeCursor);
            this.iterationExhausted = false;
            this.timestamp = timestamp;
        }

        public boolean hasNext() {
            VersionChain chain;
            ReadResult result;
            if (this.nextRead != null) {
                return true;
            }
            if (this.iterationExhausted) {
                return false;
            }
            this.currentChain = null;
            do {
                if (this.treeCursor.hasNext()) continue;
                this.iterationExhausted = true;
                return false;
            } while ((result = AbstractPageMemoryMvPartitionStorage.this.findRowVersionByTimestamp(chain = (VersionChain)this.treeCursor.next(), this.timestamp)).isEmpty() && !result.isWriteIntent());
            this.nextRead = result;
            this.currentChain = chain;
            return true;
        }
    }

    private abstract class BasePartitionTimestampCursor
    implements PartitionTimestampCursor {
        protected final Cursor<VersionChain> treeCursor;
        @Nullable
        protected ReadResult nextRead = null;
        @Nullable
        protected VersionChain currentChain = null;

        protected BasePartitionTimestampCursor(Cursor<VersionChain> treeCursor) {
            this.treeCursor = treeCursor;
        }

        public final ReadResult next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("The cursor is exhausted");
            }
            assert (this.nextRead != null);
            ReadResult res = this.nextRead;
            this.nextRead = null;
            return res;
        }

        public void close() throws Exception {
            this.treeCursor.close();
        }

        @Nullable
        public BinaryRow committed(HybridTimestamp timestamp) {
            if (this.currentChain == null) {
                throw new IllegalStateException();
            }
            ReadResult result = AbstractPageMemoryMvPartitionStorage.this.findRowVersionByTimestamp(this.currentChain, timestamp);
            if (result.isEmpty()) {
                return null;
            }
            return result.binaryRow();
        }
    }
}

