/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.Storable;
import org.apache.ignite.internal.pagememory.evict.PageEvictionTracker;
import org.apache.ignite.internal.pagememory.freelist.AbstractFreeList;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageHandler;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.io.RowVersionDataIo;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class RowVersionFreeList
extends AbstractFreeList<RowVersion> {
    private static final IgniteLogger LOG = Loggers.forClass(RowVersionFreeList.class);
    private final IoStatisticsHolder statHolder;
    private final UpdateTimestampHandler updateTimestampHandler = new UpdateTimestampHandler();

    public RowVersionFreeList(int grpId, int partId, PageMemory pageMem, @Nullable ReuseList reuseList, PageLockListener lockLsnr, long metaPageId, boolean initNew, @Nullable AtomicLong pageListCacheLimit, PageEvictionTracker evictionTracker, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
        super(grpId, partId, "RowVersionFreeList_" + grpId, pageMem, reuseList, lockLsnr, LOG, metaPageId, initNew, pageListCacheLimit, evictionTracker);
        this.statHolder = statHolder;
    }

    public void insertDataRow(RowVersion row) throws IgniteInternalCheckedException {
        super.insertDataRow((Storable)row, this.statHolder);
    }

    public void updateTimestamp(long link, HybridTimestamp newTimestamp) throws IgniteInternalCheckedException {
        this.updateDataRow(link, this.updateTimestampHandler, newTimestamp, this.statHolder);
    }

    public void removeDataRowByLink(long link) throws IgniteInternalCheckedException {
        super.removeDataRowByLink(link, this.statHolder);
    }

    public void saveMetadata() throws IgniteInternalCheckedException {
        super.saveMetadata(this.statHolder);
    }

    private class UpdateTimestampHandler
    implements PageHandler<HybridTimestamp, Object> {
        private UpdateTimestampHandler() {
        }

        public Object run(int groupId, long pageId, long page, long pageAddr, PageIo io, HybridTimestamp arg, int itemId, IoStatisticsHolder statHolder) throws IgniteInternalCheckedException {
            RowVersionDataIo dataIo = (RowVersionDataIo)io;
            dataIo.updateTimestamp(pageAddr, itemId, RowVersionFreeList.this.pageSize(), arg);
            RowVersionFreeList.this.evictionTracker.touchPage(pageId);
            return true;
        }
    }
}

