/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ComponentNotStartedException;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.RootInnerNode;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationFlattener;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.validation.MemberKey;
import org.apache.ignite.internal.configuration.validation.ValidationUtil;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.NodeStoppingException;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationChanger
implements DynamicConfigurationChanger {
    private final ForkJoinPool pool = new ForkJoinPool(2);
    private final Map<MemberKey, Annotation[]> cachedAnnotations = new ConcurrentHashMap<MemberKey, Annotation[]>();
    private final Notificator notificator;
    private final Map<String, RootKey<?, ?>> rootKeys;
    private final Map<Class<? extends Annotation>, Set<Validator<?, ?>>> validators;
    private final ConfigurationStorage storage;
    private volatile StorageRoots storageRoots;
    private final AtomicLong notificationListenerCnt = new AtomicLong();

    public ConfigurationChanger(Notificator notificator, Collection<RootKey<?, ?>> rootKeys, Map<Class<? extends Annotation>, Set<Validator<?, ?>>> validators, ConfigurationStorage storage) {
        ConfigurationUtil.checkConfigurationType(rootKeys, storage);
        this.notificator = notificator;
        this.validators = validators;
        this.storage = storage;
        this.rootKeys = rootKeys.stream().collect(Collectors.toMap(RootKey::key, Function.identity()));
    }

    public abstract InnerNode createRootNode(RootKey<?, ?> var1);

    private Function<String, RootInnerNode> rootCreator() {
        return key -> {
            RootKey<?, ?> rootKey = this.rootKeys.get(key);
            return rootKey == null ? null : new RootInnerNode(rootKey, this.createRootNode(rootKey));
        };
    }

    public void start() throws ConfigurationChangeException {
        Data data;
        try {
            data = this.storage.readDataOnRecovery().get();
        }
        catch (ExecutionException e) {
            throw new ConfigurationChangeException("Failed to initialize configuration: " + e.getCause().getMessage(), e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConfigurationChangeException("Failed to initialize configuration: " + e.getMessage(), (Throwable)e);
        }
        SuperRoot superRoot = new SuperRoot(this.rootCreator());
        Map<String, ?> dataValuesPrefixMap = ConfigurationUtil.toPrefixMap(data.values());
        for (RootKey<?, ?> rootKey : this.rootKeys.values()) {
            Map rootPrefixMap = (Map)dataValuesPrefixMap.get(rootKey.key());
            InnerNode rootNode = this.createRootNode(rootKey);
            if (rootPrefixMap != null) {
                ConfigurationUtil.fillFromPrefixMap(rootNode, rootPrefixMap);
            }
            superRoot.addRoot(rootKey, rootNode);
        }
        ConfigurationUtil.addDefaults(superRoot);
        this.storageRoots = new StorageRoots(superRoot, data.changeId());
        this.storage.registerConfigurationListener(this::updateFromListener);
    }

    public void initializeDefaults() throws ConfigurationValidationException, ConfigurationChangeException {
        try {
            ConfigurationSource defaultsCfgSource = new ConfigurationSource(){

                @Override
                public void descend(ConstructableTreeNode node) {
                    ConfigurationUtil.addDefaults((InnerNode)node);
                }
            };
            this.changeInternally(defaultsCfgSource).get(5L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConfigurationValidationException) {
                throw (ConfigurationValidationException)cause;
            }
            if (cause instanceof ConfigurationChangeException) {
                throw (ConfigurationChangeException)cause;
            }
            throw new ConfigurationChangeException("Failed to write default configuration values into the storage " + this.storage.getClass(), (Throwable)e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new ConfigurationChangeException("Failed to initialize configuration storage " + this.storage.getClass(), (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> change(ConfigurationSource source) {
        return this.changeInternally(source);
    }

    @Override
    public <T> T getLatest(List<KeyPathNode> path) {
        Map<String, ? extends Serializable> storageData;
        assert (!path.isEmpty());
        assert (path instanceof RandomAccess) : path.getClass();
        assert (!path.get((int)0).unresolvedName) : path;
        HashMap<CallSite, Map<CallSite, Integer>> extras = new HashMap<CallSite, Map<CallSite, Integer>>();
        StringJoiner prefixJoiner = new StringJoiner(".");
        int pathSize = path.size();
        KeyPathNode lastPathNode = path.get(pathSize - 1);
        for (int idx = 0; idx < pathSize; ++idx) {
            KeyPathNode keyPathNode = path.get(idx);
            if (!keyPathNode.unresolvedName) {
                if (keyPathNode.namedListEntry) {
                    prefixJoiner.add(keyPathNode.key);
                    String prefix = prefixJoiner + ".";
                    extras.put((CallSite)((Object)prefix), Map.of(prefix + "<name>", "<name_placeholder>", prefix + "<order>", 0));
                    continue;
                }
                prefixJoiner.add(keyPathNode.key);
                continue;
            }
            assert (keyPathNode.namedListEntry) : path;
            String unresolvedNameKey = prefixJoiner + ".<ids>." + ConfigurationUtil.escape(keyPathNode.key);
            Serializable resolvedName = ConfigurationChanger.get(this.storage.readLatest(unresolvedNameKey));
            if (resolvedName == null) {
                throw new NoSuchElementException(prefixJoiner + "." + ConfigurationUtil.escape(keyPathNode.key));
            }
            assert (resolvedName instanceof UUID) : resolvedName;
            UUID uUID = (UUID)resolvedName;
            if (idx == pathSize - 2 && "<internal_id>".equals(lastPathNode.key)) {
                assert (!lastPathNode.unresolvedName) : path;
                return (T)uUID;
            }
            prefixJoiner.add(uUID.toString());
            String prefix = prefixJoiner + ".";
            extras.put((CallSite)((Object)prefix), Map.of(prefix + "<name>", keyPathNode.key, prefix + "<order>", 0));
        }
        if (lastPathNode.key.equals("<internal_id>") && !lastPathNode.unresolvedName && path.get((int)(pathSize - 2)).namedListEntry) {
            assert (!path.get((int)(pathSize - 2)).unresolvedName) : path;
            String nameStorageKey = prefixJoiner.toString().replaceAll(Pattern.quote("<internal_id>") + "$", "<name>");
            Serializable name = ConfigurationChanger.get(this.storage.readLatest(nameStorageKey));
            if (name != null) {
                return (T)UUID.fromString(path.get((int)(pathSize - 2)).key);
            }
            throw new NoSuchElementException(prefixJoiner.toString());
        }
        String prefix = prefixJoiner.toString();
        if (lastPathNode.key.equals("<internal_ids>") && !lastPathNode.unresolvedName && path.get((int)(pathSize - 1)).namedListEntry) {
            prefix = prefix.replaceAll(Pattern.quote("<internal_ids>") + "$", "<ids>.");
            storageData = ConfigurationChanger.get(this.storage.readAllLatest(prefix));
            return (T)List.copyOf(storageData.values());
        }
        if (lastPathNode.key.equals("<internal_id>") && !path.get((int)(pathSize - 2)).namedListEntry) {
            prefix = prefix.replaceAll(Pattern.quote(".<internal_id>") + "$", "");
        } else if (lastPathNode.key.contains("<injected_name>")) {
            prefix = prefix.replaceAll(Pattern.quote(".<injected_name>"), "");
        }
        storageData = ConfigurationChanger.get(this.storage.readAllLatest(prefix));
        HashMap<Object, ? extends Serializable> mergedData = new HashMap<Object, Serializable>();
        if (!storageData.isEmpty()) {
            mergedData.putAll(storageData);
            block1: for (Map.Entry entry : extras.entrySet()) {
                for (String storageKey : storageData.keySet()) {
                    String extrasPrefix;
                    if (!storageKey.startsWith(extrasPrefix = (String)entry.getKey())) continue;
                    for (Map.Entry extrasEntryMap : ((Map)entry.getValue()).entrySet()) {
                        mergedData.putIfAbsent((String)extrasEntryMap.getKey(), (Serializable)extrasEntryMap.getValue());
                    }
                    continue block1;
                }
            }
            if (lastPathNode.namedListEntry) {
                mergedData.put(prefix + ".<order>", Integer.valueOf(0));
            }
        }
        SuperRoot rootNode = new SuperRoot(this.rootCreator());
        ConfigurationUtil.fillFromPrefixMap(rootNode, ConfigurationUtil.toPrefixMap(mergedData));
        if (storageData.isEmpty()) {
            ((InnerNode)rootNode).construct(path.get((int)0).key, ConfigurationUtil.EMPTY_CFG_SRC, true);
        }
        ConfigurationUtil.addDefaults(rootNode);
        return ConfigurationUtil.findEx(path, rootNode);
    }

    public void stop() throws Exception {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.pool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        StorageRoots roots = this.storageRoots;
        if (roots != null) {
            roots.changeFuture.completeExceptionally((Throwable)new NodeStoppingException());
        }
        this.storage.close();
    }

    @Override
    public InnerNode getRootNode(RootKey<?, ?> rootKey) {
        return this.storageRoots.roots.getRoot(rootKey);
    }

    public SuperRoot superRoot() {
        StorageRoots localRoots = this.storageRoots;
        if (localRoots == null) {
            throw new ComponentNotStartedException();
        }
        return localRoots.roots;
    }

    private CompletableFuture<Void> changeInternally(ConfigurationSource src) {
        StorageRoots localRoots = this.storageRoots;
        if (localRoots == null) {
            throw new ComponentNotStartedException();
        }
        return ((CompletableFuture)this.storage.lastRevision().thenCompose(storageRevision -> {
            assert (storageRevision != null);
            if (localRoots.version < storageRevision) {
                return localRoots.changeFuture.thenCompose(v -> this.changeInternally(src));
            }
            return this.changeInternally0(localRoots, src);
        })).exceptionally(throwable -> {
            Throwable cause = throwable.getCause();
            if (cause instanceof ConfigurationChangeException) {
                throw (ConfigurationChangeException)cause;
            }
            throw new ConfigurationChangeException("Failed to change configuration", cause);
        });
    }

    private CompletableFuture<Void> changeInternally0(StorageRoots localRoots, ConfigurationSource src) {
        return CompletableFuture.supplyAsync(() -> {
            SuperRoot curRoots = localRoots.roots;
            SuperRoot changes = curRoots.copy();
            src.reset();
            src.descend(changes);
            ConfigurationUtil.addDefaults(changes);
            Map<String, Serializable> allChanges = ConfigurationFlattener.createFlattenedUpdatesMap(curRoots, changes);
            ConfigurationUtil.dropNulls(changes);
            List<ValidationIssue> validationIssues = ValidationUtil.validate(curRoots, changes, this::getRootNode, this.cachedAnnotations, this.validators);
            if (!validationIssues.isEmpty()) {
                throw new ConfigurationValidationException(validationIssues);
            }
            return allChanges;
        }, this.pool).thenCompose(allChanges -> this.storage.write((Map<String, ? extends Serializable>)allChanges, localRoots.version).thenCompose(casWroteSuccessfully -> {
            if (casWroteSuccessfully.booleanValue()) {
                return localRoots.changeFuture;
            }
            return localRoots.changeFuture.thenCompose(v -> this.changeInternally(src));
        }));
    }

    private CompletableFuture<Void> updateFromListener(Data changedEntries) {
        StorageRoots oldStorageRoots = this.storageRoots;
        Map<String, ?> dataValuesPrefixMap = ConfigurationUtil.toPrefixMap(changedEntries.values());
        ConfigurationUtil.compressDeletedEntries(dataValuesPrefixMap);
        SuperRoot oldSuperRoot = oldStorageRoots.roots;
        SuperRoot newSuperRoot = oldSuperRoot.copy();
        ConfigurationUtil.fillFromPrefixMap(newSuperRoot, dataValuesPrefixMap);
        long newChangeId = changedEntries.changeId();
        this.storageRoots = new StorageRoots(newSuperRoot, newChangeId);
        return this.storage.writeConfigurationRevision(oldStorageRoots.version, this.storageRoots.version).thenCompose(unused -> {
            if (dataValuesPrefixMap.isEmpty()) {
                oldStorageRoots.changeFuture.complete(null);
                return CompletableFuture.completedFuture(null);
            }
            long notificationNumber = this.notificationListenerCnt.incrementAndGet();
            return this.notificator.notify(oldSuperRoot, newSuperRoot, newChangeId, notificationNumber).whenComplete((v, t) -> {
                if (t == null) {
                    oldStorageRoots.changeFuture.complete(null);
                } else {
                    oldStorageRoots.changeFuture.completeExceptionally((Throwable)t);
                }
            });
        });
    }

    CompletableFuture<Void> notifyCurrentConfigurationListeners() {
        StorageRoots storageRoots = this.storageRoots;
        return this.notificator.notify(null, storageRoots.roots, storageRoots.version, this.notificationListenerCnt.incrementAndGet());
    }

    @Override
    public long notificationCount() {
        return this.notificationListenerCnt.get();
    }

    private static <T> T get(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw new IgniteInternalException("Failed to read storage data", e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException("Failed to read storage data", (Throwable)e);
        }
    }

    private static class StorageRoots {
        private final SuperRoot roots;
        private final long version;
        private final CompletableFuture<Void> changeFuture = new CompletableFuture();

        private StorageRoots(SuperRoot roots, long version) {
            this.roots = roots;
            this.version = version;
        }
    }

    @FunctionalInterface
    public static interface Notificator {
        public CompletableFuture<Void> notify(@Nullable SuperRoot var1, SuperRoot var2, long var3, long var5);
    }
}

