/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.replacement;

import java.util.function.LongUnaryOperator;
import org.apache.ignite.internal.util.GridUnsafe;

public class ClockPageReplacementFlags {
    private final int pagesCnt;
    private int curIdx;
    private final long flagsPtr;

    public ClockPageReplacementFlags(int totalPagesCnt, long memPtr) {
        this.pagesCnt = totalPagesCnt;
        this.flagsPtr = memPtr;
        GridUnsafe.zeroMemory((long)this.flagsPtr, (long)(totalPagesCnt + 7 >> 3));
    }

    public int poll() {
        while (true) {
            if (this.curIdx >= this.pagesCnt) {
                this.curIdx = 0;
            }
            long ptr = this.flagsPtr + ((long)(this.curIdx >> 3) & 0xFFFFFFFFFFFFFFF8L);
            long flags = GridUnsafe.getLong((long)ptr);
            if ((this.curIdx & 0x3F) == 0 && flags == -1L) {
                GridUnsafe.putLong((long)ptr, (long)0L);
                this.curIdx += 64;
                continue;
            }
            long mask = -1L << this.curIdx;
            int bitIdx = Long.numberOfTrailingZeros((flags ^ 0xFFFFFFFFFFFFFFFFL) & mask);
            if (bitIdx == 64) {
                GridUnsafe.putLong((long)ptr, (long)(flags & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
                this.curIdx = (this.curIdx & 0xFFFFFFC0) + 64;
                continue;
            }
            GridUnsafe.putLong((long)ptr, (long)(flags & ((mask &= -1L << bitIdx ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL)));
            this.curIdx = (this.curIdx & 0xFFFFFFC0) + bitIdx + 1;
            if (this.curIdx <= this.pagesCnt) break;
        }
        return this.curIdx - 1;
    }

    boolean getFlag(int pageIdx) {
        long flags = GridUnsafe.getLong((long)(this.flagsPtr + ((long)(pageIdx >> 3) & 0xFFFFFFFFFFFFFFF8L)));
        return (flags & 1L << pageIdx) != 0L;
    }

    public void clearFlag(int pageIdx) {
        this.compareAndSwapFlag(pageIdx, flags -> flags & (1L << pageIdx ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public void setFlag(int pageIdx) {
        this.compareAndSwapFlag(pageIdx, flags -> flags | 1L << pageIdx);
    }

    private void compareAndSwapFlag(int pageIdx, LongUnaryOperator func) {
        long newFlags;
        long oldFlags;
        long ptr = this.flagsPtr + ((long)(pageIdx >> 3) & 0xFFFFFFFFFFFFFFF8L);
        do {
            if ((oldFlags = GridUnsafe.getLong((long)ptr)) != (newFlags = func.applyAsLong(oldFlags))) continue;
            return;
        } while (!GridUnsafe.compareAndSwapLong(null, (long)ptr, (long)oldFlags, (long)newFlags));
    }

    public static long requiredMemory(int pagesCnt) {
        return (long)((pagesCnt + 63) / 8) & 0xFFFFFFFFFFFFFFF8L;
    }
}

