/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractExecutable;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Described;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@Internal
public abstract class AbstractExecutableMethod
extends AbstractExecutable
implements ExecutableMethod,
EnvironmentConfigurable {
    private final ReturnType returnType;
    private final Argument<?> genericReturnType;
    private final int hashCode;
    private Environment environment;
    private AnnotationMetadata methodAnnotationMetadata;

    protected AbstractExecutableMethod(Class<?> declaringType, String methodName, Argument genericReturnType, Argument ... arguments) {
        super(declaringType, methodName, arguments);
        this.genericReturnType = genericReturnType;
        this.returnType = new ReturnTypeImpl();
        int result = Objects.hash(declaringType, methodName);
        this.hashCode = result = 31 * result + Arrays.hashCode(this.argTypes);
    }

    protected AbstractExecutableMethod(Class<?> declaringType, String methodName, Argument genericReturnType) {
        this(declaringType, methodName, genericReturnType, Argument.ZERO_ARGUMENTS);
    }

    protected AbstractExecutableMethod(Class<?> declaringType, String methodName) {
        this(declaringType, methodName, Argument.OBJECT_ARGUMENT, Argument.ZERO_ARGUMENTS);
    }

    @Override
    public boolean hasPropertyExpressions() {
        return this.getAnnotationMetadata().hasPropertyExpressions();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        if (this.methodAnnotationMetadata == null) {
            this.methodAnnotationMetadata = this.initializeAnnotationMetadata();
        }
        return this.methodAnnotationMetadata;
    }

    @Override
    public void configure(Environment environment) {
        this.environment = environment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractExecutableMethod that = (AbstractExecutableMethod)o;
        return Objects.equals(this.declaringType, that.declaringType) && Objects.equals(this.methodName, that.methodName) && Arrays.equals(this.argTypes, that.argTypes);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String text = Argument.toString((Argument[])this.getArguments());
        return this.getReturnType().getType().getSimpleName() + " " + this.getMethodName() + "(" + text + ")";
    }

    @Override
    public ReturnType getReturnType() {
        return this.returnType;
    }

    @Override
    public Class[] getArgumentTypes() {
        return this.argTypes;
    }

    @Override
    public Class getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public final Object invoke(Object instance, Object ... arguments) {
        ArgumentUtils.validateArguments((Described)this, (Argument[])this.getArguments(), (Object[])arguments);
        return this.invokeInternal(instance, arguments);
    }

    protected abstract Object invokeInternal(Object var1, Object[] var2);

    protected AnnotationMetadata resolveAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private AnnotationMetadata initializeAnnotationMetadata() {
        AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata();
        if (annotationMetadata != AnnotationMetadata.EMPTY_METADATA) {
            if (annotationMetadata.hasPropertyExpressions()) {
                return new MethodAnnotationMetadata(annotationMetadata);
            }
            return annotationMetadata;
        }
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private final class MethodAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        MethodAnnotationMetadata(AnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return AbstractExecutableMethod.this.environment;
        }
    }

    class ReturnTypeImpl
    implements ReturnType {
        ReturnTypeImpl() {
        }

        public Class<?> getType() {
            if (AbstractExecutableMethod.this.genericReturnType != null) {
                return AbstractExecutableMethod.this.genericReturnType.getType();
            }
            return Void.TYPE;
        }

        public boolean isSuspended() {
            return AbstractExecutableMethod.this.isSuspend();
        }

        @NonNull
        public AnnotationMetadata getAnnotationMetadata() {
            return AbstractExecutableMethod.this.getAnnotationMetadata();
        }

        public Argument[] getTypeParameters() {
            if (AbstractExecutableMethod.this.genericReturnType != null) {
                return AbstractExecutableMethod.this.genericReturnType.getTypeParameters();
            }
            return Argument.ZERO_ARGUMENTS;
        }

        public Map<String, Argument<?>> getTypeVariables() {
            if (AbstractExecutableMethod.this.genericReturnType != null) {
                return AbstractExecutableMethod.this.genericReturnType.getTypeVariables();
            }
            return Collections.emptyMap();
        }

        @NonNull
        public Argument asArgument() {
            Map<String, Argument<?>> typeVariables = this.getTypeVariables();
            Collection<Argument<?>> values = typeVariables.values();
            AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
            return Argument.of(this.getType(), (AnnotationMetadata)annotationMetadata, (Argument[])values.toArray(Argument.ZERO_ARGUMENTS));
        }
    }
}

