/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.cli;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class ChangePeersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ChangePeersRequest> {
    public ChangePeersRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.ChangePeersRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.ChangePeersRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ChangePeersRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> oldConf = ctx.node.listPeers();
        Configuration conf = new Configuration();
        Iterator<String> iterator = request.newPeersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerIdStr = iterator.next();
            if (peer.parse(peerIdStr)) {
                conf.addPeer(peer);
                continue;
            }
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", peerIdStr);
        }
        LOG.info("Receive ChangePeersRequest to {} from {}, new conf is {}", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), conf});
        ctx.node.changePeers(conf, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.ChangePeersResponse req = this.msgFactory().changePeersResponse().oldPeersList(oldConf.stream().map(Object::toString).collect(Collectors.toList())).newPeersList(conf.getPeers().stream().map(Object::toString).collect(Collectors.toList())).build();
                done.sendResponse(req);
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.ChangePeersRequest.class.getName();
    }
}

