/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.core;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.error.RemotingException;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.option.RpcOptions;
import org.apache.ignite.raft.jraft.rpc.InvokeContext;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftClientService;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.RpcResponseClosure;
import org.apache.ignite.raft.jraft.rpc.impl.AbstractClientService;
import org.apache.ignite.raft.jraft.util.Endpoint;

public class DefaultRaftClientService
extends AbstractClientService
implements RaftClientService {
    private final ConcurrentMap<Endpoint, Executor> appendEntriesExecutorMap = new ConcurrentHashMap<Endpoint, Executor>();
    private NodeOptions nodeOptions;

    @Override
    public synchronized boolean init(RpcOptions rpcOptions) {
        boolean ret = super.init(rpcOptions);
        if (ret) {
            this.nodeOptions = (NodeOptions)rpcOptions;
        }
        return ret;
    }

    @Override
    public Future<Message> preVote(Endpoint endpoint, RpcRequests.RequestVoteRequest request, RpcResponseClosure<RpcRequests.RequestVoteResponse> done) {
        return this.invokeWithDone(endpoint, request, done, this.nodeOptions.getElectionTimeoutMs());
    }

    @Override
    public Future<Message> requestVote(Endpoint endpoint, RpcRequests.RequestVoteRequest request, RpcResponseClosure<RpcRequests.RequestVoteResponse> done) {
        return this.invokeWithDone(endpoint, request, done, this.nodeOptions.getElectionTimeoutMs());
    }

    @Override
    public Future<Message> appendEntries(Endpoint endpoint, RpcRequests.AppendEntriesRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.AppendEntriesResponse> done) {
        Executor executor = this.appendEntriesExecutorMap.computeIfAbsent(endpoint, k -> this.nodeOptions.getStripedExecutor().next());
        if (this.connect(endpoint)) {
            return this.invokeWithDone(endpoint, (Message)request, done, timeoutMs, executor);
        }
        return this.failedFuture(executor, request, done, endpoint);
    }

    @Override
    public Future<Message> getFile(Endpoint endpoint, RpcRequests.GetFileRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.GetFileResponse> done) {
        InvokeContext ctx = new InvokeContext();
        return this.invokeWithDone(endpoint, (Message)request, ctx, done, timeoutMs);
    }

    @Override
    public Future<Message> installSnapshot(Endpoint endpoint, RpcRequests.InstallSnapshotRequest request, RpcResponseClosure<RpcRequests.InstallSnapshotResponse> done) {
        if (this.connect(endpoint)) {
            return this.invokeWithDone(endpoint, request, done, this.rpcOptions.getRpcInstallSnapshotTimeout());
        }
        return this.failedFuture(this.rpcExecutor, request, done, endpoint);
    }

    @Override
    public Future<Message> timeoutNow(Endpoint endpoint, RpcRequests.TimeoutNowRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.TimeoutNowResponse> done) {
        return this.invokeWithDone(endpoint, request, done, timeoutMs);
    }

    @Override
    public Future<Message> readIndex(Endpoint endpoint, RpcRequests.ReadIndexRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.ReadIndexResponse> done) {
        return this.invokeWithDone(endpoint, request, done, timeoutMs);
    }

    private Future<Message> failedFuture(Executor executor, Message request, RpcResponseClosure<?> done, Endpoint endpoint) {
        CompletableFuture<Message> future = new CompletableFuture<Message>();
        executor.execute(() -> {
            if (done != null) {
                try {
                    done.run(new Status(RaftError.EINTERNAL, "Check connection[%s] fail and try to create new one", endpoint));
                }
                catch (Throwable t) {
                    LOG.error("Fail to run RpcResponseClosure, the request is {}.", t, new Object[]{request});
                }
            }
            future.completeExceptionally(new RemotingException("Check connection[" + endpoint.toString() + "] fail and try to create new one"));
        });
        return future;
    }
}

