/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringBuilder;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.NodeStoppingException;
import org.jetbrains.annotations.Nullable;

public class IgniteUtils {
    private static final int MASK = 15;
    private static final long BEGINNING_OF_TIME = System.nanoTime();
    private static final String jdkVer = System.getProperty("java.specification.version");
    private static final ClassLoader igniteClassLoader = IgniteUtils.class.getClassLoader();
    private static final boolean assertionsEnabled = IgniteUtils.class.desiredAssertionStatus();
    private static final Map<String, Class<?>> primitiveMap = Map.of("byte", Byte.TYPE, "short", Short.TYPE, "int", Integer.TYPE, "long", Long.TYPE, "float", Float.TYPE, "double", Double.TYPE, "char", Character.TYPE, "boolean", Boolean.TYPE, "void", Void.TYPE);
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<String, Class<?>>> classCache = new ConcurrentHashMap();
    private static final String JMX_MBEAN_PACKAGE = "org.apache";
    private static final DateTimeFormatter SHORT_DATE_FMT = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static long monotonicMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - BEGINNING_OF_TIME);
    }

    public static String jdkVersion() {
        return jdkVer;
    }

    public static int majorJavaVersion(String verStr) {
        if (verStr == null || verStr.isEmpty()) {
            return 0;
        }
        try {
            String[] parts = verStr.split("\\.");
            int major = Integer.parseInt(parts[0]);
            if (parts.length == 1) {
                return major;
            }
            int minor = Integer.parseInt(parts[1]);
            return major == 1 ? minor : major;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int capacity(int expSize) {
        if (expSize < 3) {
            return expSize + 1;
        }
        if (expSize < 0x40000000) {
            return expSize + expSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> HashMap<K, V> newHashMap(int expSize) {
        return new HashMap(IgniteUtils.capacity(expSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int expSize) {
        return new LinkedHashMap(IgniteUtils.capacity(expSize));
    }

    public static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    public static int hash(Object obj) {
        return IgniteUtils.hash(obj.hashCode());
    }

    public static int hash(long key) {
        int val = (int)(key ^ key >>> 32);
        return IgniteUtils.hash(val);
    }

    public static String toHexString(byte[] arr) {
        return IgniteUtils.toHexString(arr, Integer.MAX_VALUE);
    }

    public static String toHexString(byte[] arr, int maxLen) {
        assert (maxLen >= 0) : "maxLem must be not negative.";
        int capacity = Math.min(arr.length << 1, maxLen);
        int lim = capacity >> 1;
        StringBuilder sb = new StringBuilder(capacity);
        for (int i = 0; i < lim; ++i) {
            IgniteUtils.addByteAsHex(sb, arr[i]);
        }
        return sb.toString().toUpperCase();
    }

    public static String toHexString(long addr, int len) {
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            IgniteUtils.addByteAsHex(sb, GridUnsafe.getByte(addr + (long)i));
        }
        return sb.toString();
    }

    public static String toHexString(ByteBuffer buf) {
        StringBuilder sb = new StringBuilder(buf.capacity() * 2);
        for (int i = buf.position(); i < buf.limit(); ++i) {
            IgniteUtils.addByteAsHex(sb, buf.get(i));
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String s) {
        int len = s.length();
        assert ((len & 1) == 0) : "length should be even";
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static void addByteAsHex(StringBuilder sb, byte b) {
        sb.append(Integer.toHexString(0xF & b >>> 4)).append(Integer.toHexString(0xF & b));
    }

    public static String hexLong(long val) {
        return new IgniteStringBuilder(16).appendHex(val).toString();
    }

    public static String hexInt(int val) {
        return new IgniteStringBuilder(8).appendHex(val).toString();
    }

    public static String readableSize(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static int safeAbs(int i) {
        return Math.max(Math.abs(i), 0);
    }

    public static long safeAbs(long i) {
        return Math.max(Math.abs(i), 0L);
    }

    @SafeVarargs
    @Nullable
    public static <T> T firstNotNull(T ... vals) {
        if (vals == null) {
            return null;
        }
        for (T val : vals) {
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public static ClassLoader igniteClassLoader() {
        return igniteClassLoader;
    }

    public static Class<?> forName(String clsName, @Nullable ClassLoader ldr) throws ClassNotFoundException {
        return IgniteUtils.forName(clsName, ldr, null);
    }

    public static Class<?> forName(String clsName, @Nullable ClassLoader ldr, Predicate<String> clsFilter) throws ClassNotFoundException {
        Class<?> old;
        ConcurrentMap<String, Class<?>> ldrMap;
        assert (clsName != null);
        Class<?> cls = primitiveMap.get(clsName);
        if (cls != null) {
            return cls;
        }
        if (ldr == null) {
            ldr = igniteClassLoader;
        }
        if ((ldrMap = (ConcurrentHashMap)classCache.get(ldr)) == null && (old = (ConcurrentMap)classCache.putIfAbsent(ldr, ldrMap = new ConcurrentHashMap())) != null) {
            ldrMap = old;
        }
        if ((cls = (Class<?>)ldrMap.get(clsName)) == null) {
            if (clsFilter != null && !clsFilter.test(clsName)) {
                throw new ClassNotFoundException("Deserialization of class " + clsName + " is disallowed.");
            }
            cls = Class.forName(clsName, true, ldr);
            old = ldrMap.putIfAbsent(clsName, cls);
            if (old != null) {
                cls = old;
            }
        }
        return cls;
    }

    public static boolean deleteIfExists(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
            return true;
        }
        catch (NoSuchFileException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean assertionsEnabled() {
        return assertionsEnabled;
    }

    public static void shutdownAndAwaitTermination(ExecutorService service, long timeout, TimeUnit unit) {
        long halfTimeoutNanos = unit.toNanos(timeout) / 2L;
        service.shutdown();
        try {
            if (!service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS)) {
                service.shutdownNow();
                service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            service.shutdownNow();
        }
    }

    public static void closeAll(Stream<? extends AutoCloseable> closeables) throws Exception {
        AtomicReference ex = new AtomicReference();
        closeables.filter(Objects::nonNull).forEach(closeable -> {
            block2: {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (ex.compareAndSet(null, e)) break block2;
                    ((Exception)ex.get()).addSuppressed(e);
                }
            }
        });
        if (ex.get() != null) {
            throw (Exception)ex.get();
        }
    }

    public static void closeAll(Collection<? extends AutoCloseable> closeables) throws Exception {
        IgniteUtils.closeAll(closeables.stream());
    }

    public static void closeAll(AutoCloseable ... closeables) throws Exception {
        IgniteUtils.closeAll(Arrays.stream(closeables));
    }

    public static void dumpStack(IgniteLogger log, String msg, Object ... params) {
        String reason = "Dumping stack";
        Exception err = new Exception(IgniteStringFormatter.format(msg, params));
        if (log != null) {
            log.warn(reason, (Throwable)err);
        } else {
            System.err.println("[" + LocalDateTime.now().format(SHORT_DATE_FMT) + "] (err) " + reason);
            err.printStackTrace(System.err);
        }
    }

    public static Path atomicMoveFile(Path sourcePath, Path targetPath, @Nullable IgniteLogger log) throws IOException {
        Path success;
        Objects.requireNonNull(sourcePath, "sourcePath");
        Objects.requireNonNull(targetPath, "targetPath");
        try {
            success = Files.move(sourcePath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            if (log != null) {
                if (e instanceof AtomicMoveNotSupportedException) {
                    log.info("Atomic move not supported. Falling back to non-atomic move [reason={}]", e.getMessage());
                } else {
                    log.info("Unable to move atomically. Falling back to non-atomic move [reason={}]", e.getMessage());
                }
                if (targetPath.toFile().exists() && log.isInfoEnabled()) {
                    log.info("The target file already exists [path={}]", targetPath);
                }
            }
            try {
                success = Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e1) {
                e1.addSuppressed(e);
                if (log != null) {
                    log.warn("Unable to move file. Going to delete source [sourcePath={}, targetPath={}]", sourcePath, targetPath);
                }
                try {
                    Files.deleteIfExists(sourcePath);
                }
                catch (IOException e2) {
                    e2.addSuppressed(e1);
                    if (log != null) {
                        log.warn("Unable to delete file [path={}]", sourcePath);
                    }
                    throw e2;
                }
                throw e1;
            }
        }
        return success;
    }

    public static <O> O nonNullOrElse(O obj, O defaultObj) {
        return obj != null ? obj : defaultObj;
    }

    public static boolean isPow2(int i) {
        return i > 0 && (i & i - 1) == 0;
    }

    public static boolean isPow2(long i) {
        return i > 0L && (i & i - 1L) == 0L;
    }

    public static <T> T getUninterruptibly(CompletableFuture<T> future) throws ExecutionException {
        boolean interrupted = false;
        while (true) {
            try {
                T t = future.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void awaitForWorkersStop(Collection<IgniteWorker> workers, boolean cancel, @Nullable IgniteLogger log) {
        if (cancel) {
            workers.forEach(IgniteWorker::cancel);
        }
        for (IgniteWorker worker : workers) {
            try {
                worker.join();
            }
            catch (Exception e) {
                if (log == null || !log.isWarnEnabled()) continue;
                log.debug("Unable to cancel ignite worker [worker={}, reason={}]", worker.toString(), e.getMessage());
            }
        }
    }

    public static <T> T inBusyLock(IgniteSpinBusyLock busyLock, Supplier<T> fn) {
        if (!busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            T t = fn.get();
            return t;
        }
        finally {
            busyLock.leaveBusy();
        }
    }

    public static void inBusyLock(IgniteSpinBusyLock busyLock, Runnable fn) {
        if (!busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            fn.run();
        }
        finally {
            busyLock.leaveBusy();
        }
    }

    public static <T> List<T> collectStaticFields(Class<?> sourceCls, Class<? extends T> targetCls) {
        ArrayList<T> result = new ArrayList<T>();
        for (Field f : sourceCls.getDeclaredFields()) {
            if (!targetCls.equals(f.getType()) || !Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) continue;
            try {
                T value = targetCls.cast(f.get(sourceCls));
                result.add(value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        return result;
    }

    public static ObjectName makeMbeanName(String group, String name) throws MalformedObjectNameException {
        return new ObjectName(String.format("%s:group=%s,name=%s", JMX_MBEAN_PACKAGE, group, name));
    }
}

