/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tx;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;

public interface IgniteTransactions {
    public IgniteTransactions withTimeout(long var1);

    public IgniteTransactions readOnly();

    public Transaction begin();

    public CompletableFuture<Transaction> beginAsync();

    default public void runInTransaction(Consumer<Transaction> clo) throws TransactionException {
        this.runInTransaction((Transaction tx) -> {
            clo.accept((Transaction)tx);
            return null;
        });
    }

    default public <T> T runInTransaction(Function<Transaction, T> clo) throws TransactionException {
        Transaction tx = this.begin();
        try {
            T ret = clo.apply(tx);
            tx.commit();
            return ret;
        }
        catch (Throwable t) {
            try {
                tx.rollback();
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    default public <T> CompletableFuture<T> runInTransactionAsync(Function<Transaction, CompletableFuture<T>> clo) {
        return this.beginAsync().thenCompose(tx -> {
            try {
                return ((CompletableFuture)((CompletableFuture)((CompletableFuture)clo.apply((Transaction)tx)).handle((res, e) -> {
                    if (e != null) {
                        return ((CompletableFuture)tx.rollbackAsync().exceptionally(e0 -> {
                            e.addSuppressed((Throwable)e0);
                            return null;
                        })).thenCompose(ignored -> CompletableFuture.failedFuture(e));
                    }
                    return CompletableFuture.completedFuture(res);
                })).thenCompose(Function.identity())).thenCompose(val -> tx.commitAsync().thenApply(ignored -> val));
            }
            catch (Exception e2) {
                return ((CompletableFuture)tx.rollbackAsync().exceptionally(e0 -> {
                    e2.addSuppressed((Throwable)e0);
                    return null;
                })).thenCompose(ignored -> CompletableFuture.failedFuture(e2));
            }
        });
    }
}

