/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.table.InvokeProcessor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientRecordBinaryView
implements RecordView<Tuple> {
    private final ClientTable tbl;
    private final ClientTupleSerializer ser;

    public ClientRecordBinaryView(ClientTable tbl) {
        assert (tbl != null);
        this.tbl = tbl;
        this.ser = new ClientTupleSerializer(tbl.tableId());
    }

    public Tuple get(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        return ClientUtils.sync(this.getAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> ClientTupleSerializer.readValueTuple(s, r, keyRec), null, ClientTupleSerializer.getHashFunction(tx, keyRec));
    }

    public Collection<Tuple> getAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs) {
        return ClientUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> getAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s, w) -> this.ser.writeTuples(tx, keyRecs, (ClientSchema)s, (PayloadOutputChannel)w, true), ClientTupleSerializer::readTuplesNullable, Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, keyRecs.iterator().next()));
    }

    public void upsert(@Nullable Transaction tx, @NotNull Tuple rec) {
        ClientUtils.sync(this.upsertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w), r -> null, ClientTupleSerializer.getHashFunction(tx, rec));
    }

    public void upsertAll(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        ClientUtils.sync(this.upsertAllAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.tbl.doSchemaOutOpAsync(13, (s, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, false), r -> null, ClientTupleSerializer.getHashFunction(tx, recs.iterator().next()));
    }

    public Tuple getAndUpsert(@Nullable Transaction tx, @NotNull Tuple rec) {
        return ClientUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndUpsertAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), (s, r) -> ClientTupleSerializer.readValueTuple(s, r, rec), null, ClientTupleSerializer.getHashFunction(tx, rec));
    }

    public boolean insert(@Nullable Transaction tx, @NotNull Tuple rec) {
        return ClientUtils.sync(this.insertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, rec));
    }

    public Collection<Tuple> insertAll(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        return ClientUtils.sync(this.insertAllAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> insertAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(20, (s, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientTupleSerializer::readTuples, Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, recs.iterator().next()));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull Tuple rec) {
        return ClientUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull Tuple oldRec, @NotNull Tuple newRec) {
        return ClientUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull Tuple oldRec, @NotNull Tuple newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (s, w) -> {
            this.ser.writeTuple(tx, oldRec, (ClientSchema)s, (PayloadOutputChannel)w, false, false);
            this.ser.writeTuple(tx, newRec, (ClientSchema)s, (PayloadOutputChannel)w, false, true);
        }, ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, oldRec));
    }

    public Tuple getAndReplace(@Nullable Transaction tx, @NotNull Tuple rec) {
        return ClientUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), (s, r) -> ClientTupleSerializer.readValueTuple(s, r, rec), null, ClientTupleSerializer.getHashFunction(tx, rec));
    }

    public boolean delete(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        return ClientUtils.sync(this.deleteAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (s, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, true), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, keyRec));
    }

    public boolean deleteExact(@Nullable Transaction tx, @NotNull Tuple rec) {
        return ClientUtils.sync(this.deleteExactAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (s, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientMessageUnpacker::unpackBoolean, ClientTupleSerializer.getHashFunction(tx, rec));
    }

    public Tuple getAndDelete(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        return ClientUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndDeleteAsync(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (s, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> ClientTupleSerializer.readValueTuple(s, r, keyRec), null, ClientTupleSerializer.getHashFunction(tx, keyRec));
    }

    public Collection<Tuple> deleteAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs) {
        return ClientUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> deleteAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s, w) -> this.ser.writeTuples(tx, keyRecs, (ClientSchema)s, (PayloadOutputChannel)w, true), (s, r) -> ClientTupleSerializer.readTuples(s, r, true), Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, keyRecs.iterator().next()));
    }

    public Collection<Tuple> deleteAllExact(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        return ClientUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> deleteAllExactAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.tbl.doSchemaOutInOpAsync(31, (s, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s, (PayloadOutputChannel)w, false), ClientTupleSerializer::readTuples, Collections.emptyList(), ClientTupleSerializer.getHashFunction(tx, recs.iterator().next()));
    }

    public <T extends Serializable> T invoke(@Nullable Transaction tx, @NotNull Tuple keyRec, InvokeProcessor<Tuple, Tuple, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <T extends Serializable> CompletableFuture<T> invokeAsync(@Nullable Transaction tx, @NotNull Tuple keyRec, InvokeProcessor<Tuple, Tuple, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <T extends Serializable> Map<Tuple, T> invokeAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs, InvokeProcessor<Tuple, Tuple, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <T extends Serializable> CompletableFuture<Map<Tuple, T>> invokeAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs, InvokeProcessor<Tuple, Tuple, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

