/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineView;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumnsFreeList;
import org.apache.ignite.internal.storage.pagememory.index.hash.PageMemoryHashIndexStorage;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.index.sorted.PageMemorySortedIndexStorage;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersionFreeList;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryMvPartitionStorage
extends AbstractPageMemoryMvPartitionStorage {
    private final CheckpointManager checkpointManager;
    private final CheckpointTimeoutLock checkpointTimeoutLock;
    private final PartitionMeta meta;
    private volatile long persistedIndex;
    private final CheckpointListener checkpointListener;

    public PersistentPageMemoryMvPartitionStorage(PersistentPageMemoryTableStorage tableStorage, int partitionId, final PartitionMeta meta, RowVersionFreeList rowVersionFreeList, IndexColumnsFreeList indexFreeList, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, TablesConfiguration tablesCfg) {
        super(partitionId, tableStorage, rowVersionFreeList, indexFreeList, versionChainTree, indexMetaTree, tablesCfg);
        this.checkpointManager = tableStorage.engine().checkpointManager();
        this.checkpointTimeoutLock = this.checkpointManager.checkpointTimeoutLock();
        this.checkpointListener = new CheckpointListener(){

            public void beforeCheckpointBegin(CheckpointProgress progress, @Nullable Executor exec) throws IgniteInternalCheckedException {
                PersistentPageMemoryMvPartitionStorage.this.syncMetadataOnCheckpoint(exec);
            }

            public void onMarkCheckpointBegin(CheckpointProgress progress, @Nullable Executor exec) throws IgniteInternalCheckedException {
                PersistentPageMemoryMvPartitionStorage.this.syncMetadataOnCheckpoint(exec);
            }

            public void afterCheckpointEnd(CheckpointProgress progress) {
                PersistentPageMemoryMvPartitionStorage.this.persistedIndex = meta.metaSnapshot(progress.id()).lastAppliedIndex();
            }
        };
        this.checkpointManager.addCheckpointListener(this.checkpointListener, (DataRegion)tableStorage.dataRegion());
        this.meta = meta;
    }

    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        this.checkpointTimeoutLock.checkpointReadLock();
        try {
            Object object = closure.execute();
            return (V)object;
        }
        finally {
            this.checkpointTimeoutLock.checkpointReadUnlock();
        }
    }

    public CompletableFuture<Void> flush() {
        CheckpointProgress scheduledCheckpoint;
        CheckpointProgress lastCheckpoint = this.checkpointManager.lastCheckpointProgress();
        if (lastCheckpoint != null && this.meta.metaSnapshot(lastCheckpoint.id()).lastAppliedIndex() == this.meta.lastAppliedIndex()) {
            scheduledCheckpoint = lastCheckpoint;
        } else {
            PersistentPageMemoryTableStorage persistentTableStorage = (PersistentPageMemoryTableStorage)this.tableStorage;
            PersistentPageMemoryStorageEngineView engineCfg = (PersistentPageMemoryStorageEngineView)persistentTableStorage.engine().configuration().value();
            int checkpointDelayMillis = engineCfg.checkpoint().checkpointDelayMillis();
            scheduledCheckpoint = this.checkpointManager.scheduleCheckpoint((long)checkpointDelayMillis, "Triggered by replicator");
        }
        return scheduledCheckpoint.futureFor(CheckpointState.FINISHED).thenApply(res -> null);
    }

    public long lastAppliedIndex() {
        return this.meta.lastAppliedIndex();
    }

    public void lastAppliedIndex(long lastAppliedIndex) throws StorageException {
        assert (this.checkpointTimeoutLock.checkpointLockIsHeldByThread());
        CheckpointProgress lastCheckpoint = this.checkpointManager.lastCheckpointProgress();
        UUID lastCheckpointId = lastCheckpoint == null ? null : lastCheckpoint.id();
        this.meta.lastAppliedIndex(lastCheckpointId, lastAppliedIndex);
    }

    public long persistedIndex() {
        return this.persistedIndex;
    }

    @Override
    public PageMemoryHashIndexStorage getOrCreateHashIndex(UUID indexId) {
        return (PageMemoryHashIndexStorage)this.runConsistently(() -> super.getOrCreateHashIndex(indexId));
    }

    @Override
    public PageMemorySortedIndexStorage getOrCreateSortedIndex(UUID indexId) {
        return (PageMemorySortedIndexStorage)this.runConsistently(() -> super.getOrCreateSortedIndex(indexId));
    }

    @Override
    public void close() {
        this.checkpointManager.removeCheckpointListener(this.checkpointListener);
        this.rowVersionFreeList.close();
        this.indexFreeList.close();
    }

    private void syncMetadataOnCheckpoint(@Nullable Executor executor) throws IgniteInternalCheckedException {
        if (executor == null) {
            this.rowVersionFreeList.saveMetadata();
            this.indexFreeList.saveMetadata();
        } else {
            executor.execute(() -> {
                try {
                    this.rowVersionFreeList.saveMetadata();
                }
                catch (IgniteInternalCheckedException e) {
                    throw new IgniteInternalException("Failed to save RowVersionFreeList metadata", (Throwable)e);
                }
            });
            executor.execute(() -> {
                try {
                    this.indexFreeList.saveMetadata();
                }
                catch (IgniteInternalCheckedException e) {
                    throw new IgniteInternalException("Failed to save IndexColumnsFreeList metadata", (Throwable)e);
                }
            });
        }
    }
}

