/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.core.Scheduler;
import org.apache.ignite.raft.jraft.core.TimerManager;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.option.BootstrapOptions;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.option.RpcOptions;
import org.apache.ignite.raft.jraft.util.Endpoint;
import org.apache.ignite.raft.jraft.util.StringUtils;
import org.apache.ignite.raft.jraft.util.ThreadPoolUtil;
import org.apache.ignite.raft.jraft.util.Utils;
import org.apache.ignite.raft.jraft.util.concurrent.DefaultFixedThreadsExecutorGroupFactory;
import org.apache.ignite.raft.jraft.util.concurrent.FixedThreadsExecutorGroup;
import org.apache.ignite.raft.jraft.util.timer.DefaultTimer;
import org.apache.ignite.raft.jraft.util.timer.Timer;

public final class JRaftUtils {
    private static final IgniteLogger LOG = Loggers.forClass(JRaftUtils.class);

    public static boolean bootstrap(BootstrapOptions opts) throws InterruptedException {
        NodeImpl node = new NodeImpl("bootstrap", new PeerId("127.0.0.1", 0));
        NodeOptions nodeOpts = opts.getNodeOptions();
        nodeOpts.setStripes(1);
        boolean ret = node.bootstrap(opts);
        node.shutdown();
        node.join();
        return ret;
    }

    public static ExecutorService createExecutor(String prefix, int number) {
        if (number <= 0) {
            throw new IllegalArgumentException();
        }
        return ThreadPoolUtil.newBuilder().poolName(prefix).enableMetric(true).coreThreads(number).maximumThreads(number).keepAliveSeconds(60L).workQueue(new LinkedBlockingQueue<Runnable>()).threadFactory(JRaftUtils.createThreadFactory(prefix)).build();
    }

    public static ExecutorService createCommonExecutor(NodeOptions opts) {
        return JRaftUtils.createExecutor(NamedThreadFactory.threadPrefix((String)opts.getServerName(), (String)"JRaft-Common-Executor"), opts.getCommonThreadPollSize());
    }

    public static FixedThreadsExecutorGroup createAppendEntriesExecutor(NodeOptions opts) {
        return JRaftUtils.createStripedExecutor(NamedThreadFactory.threadPrefix((String)opts.getServerName(), (String)"JRaft-AppendEntries-Processor"), Utils.APPEND_ENTRIES_THREADS_POOL_SIZE, Utils.MAX_APPEND_ENTRIES_TASKS_PER_THREAD);
    }

    public static ExecutorService createRequestExecutor(NodeOptions opts) {
        return JRaftUtils.createExecutor(NamedThreadFactory.threadPrefix((String)opts.getServerName(), (String)"JRaft-Request-Processor"), opts.getRaftRpcThreadPoolSize());
    }

    public static ExecutorService createClientExecutor(RpcOptions opts, String name) {
        String prefix = NamedThreadFactory.threadPrefix((String)name, (String)"JRaft-Response-Processor");
        return ThreadPoolUtil.newBuilder().poolName(prefix).enableMetric(true).coreThreads(opts.getRpcProcessorThreadPoolSize() / 3).maximumThreads(opts.getRpcProcessorThreadPoolSize()).keepAliveSeconds(60L).workQueue(new ArrayBlockingQueue<Runnable>(10000)).threadFactory(JRaftUtils.createThreadFactory(prefix)).build();
    }

    public static Scheduler createScheduler(NodeOptions opts) {
        return new TimerManager(opts.getTimerPoolSize(), NamedThreadFactory.threadPrefix((String)opts.getServerName(), (String)"JRaft-Node-Scheduler"));
    }

    public static Timer createTimer(NodeOptions opts, String name) {
        return new DefaultTimer(opts.getTimerPoolSize(), NamedThreadFactory.threadPrefix((String)opts.getServerName(), (String)name));
    }

    public static FixedThreadsExecutorGroup createStripedExecutor(String prefix, int number, int tasksPerThread) {
        return DefaultFixedThreadsExecutorGroupFactory.INSTANCE.newExecutorGroup(number, prefix, tasksPerThread, true);
    }

    public static ThreadFactory createThreadFactory(String prefixName) {
        return new NamedThreadFactory(prefixName, true, LOG);
    }

    public static Configuration getConfiguration(String s) {
        Configuration conf = new Configuration();
        if (StringUtils.isBlank(s)) {
            return conf;
        }
        if (conf.parse(s)) {
            return conf;
        }
        throw new IllegalArgumentException("Invalid conf str:" + s);
    }

    public static PeerId getPeerId(String s) {
        PeerId peer = new PeerId();
        if (StringUtils.isBlank(s)) {
            return peer;
        }
        if (peer.parse(s)) {
            return peer;
        }
        throw new IllegalArgumentException("Invalid peer str:" + s);
    }

    public static NetworkAddress addressFromEndpoint(Endpoint endpoint) {
        return new NetworkAddress(endpoint.getIp(), endpoint.getPort());
    }

    private JRaftUtils() {
    }
}

