/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.index;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.configuration.ColumnTypeView;
import org.apache.ignite.internal.schema.configuration.ColumnView;
import org.apache.ignite.internal.schema.configuration.ConfigurationToSchemaDescriptorConverter;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesView;
import org.apache.ignite.internal.schema.configuration.index.IndexColumnView;
import org.apache.ignite.internal.schema.configuration.index.SortedIndexView;
import org.apache.ignite.internal.schema.configuration.index.TableIndexView;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.IndexDescriptor;
import org.apache.ignite.internal.tostring.S;

public class SortedIndexDescriptor
implements IndexDescriptor {
    private final UUID id;
    private final List<SortedIndexColumnDescriptor> columns;
    private final BinaryTupleSchema binaryTupleSchema;

    public SortedIndexDescriptor(UUID indexId, TablesView tablesConfig) {
        this(indexId, SortedIndexDescriptor.extractIndexColumnsConfiguration(indexId, tablesConfig));
    }

    public SortedIndexDescriptor(UUID indexId, List<SortedIndexColumnDescriptor> columnDescriptors) {
        this.id = indexId;
        this.columns = List.copyOf(columnDescriptors);
        this.binaryTupleSchema = SortedIndexDescriptor.createSchema(this.columns);
    }

    private static List<SortedIndexColumnDescriptor> extractIndexColumnsConfiguration(UUID indexId, TablesView tablesConfig) {
        TableIndexView indexConfig = (TableIndexView)ConfigurationUtil.getByInternalId((NamedListView)tablesConfig.indexes(), (UUID)indexId);
        if (indexConfig == null) {
            throw new StorageException(String.format("Index configuration for \"%s\" could not be found", indexId));
        }
        if (!(indexConfig instanceof SortedIndexView)) {
            throw new StorageException(String.format("Index \"%s\" is not configured as a Sorted Index. Actual type: %s", indexId, indexConfig.type()));
        }
        TableView tableConfig = (TableView)ConfigurationUtil.getByInternalId((NamedListView)tablesConfig.tables(), (UUID)indexConfig.tableId());
        if (tableConfig == null) {
            throw new StorageException(String.format("Table configuration for \"%s\" could not be found", indexConfig.tableId()));
        }
        NamedListView indexColumns = ((SortedIndexView)indexConfig).columns();
        return indexColumns.namedListKeys().stream().map(columnName -> {
            ColumnView columnView = (ColumnView)tableConfig.columns().get(columnName);
            assert (columnView != null) : "Incorrect index column configuration. " + columnName + " column does not exist";
            IndexColumnView indexColumnView = (IndexColumnView)indexColumns.get(columnName);
            return new SortedIndexColumnDescriptor(columnView, indexColumnView);
        }).collect(Collectors.toUnmodifiableList());
    }

    private static BinaryTupleSchema createSchema(List<SortedIndexColumnDescriptor> columns) {
        BinaryTupleSchema.Element[] elements = (BinaryTupleSchema.Element[])columns.stream().map(columnDescriptor -> new BinaryTupleSchema.Element(columnDescriptor.type(), columnDescriptor.nullable())).toArray(BinaryTupleSchema.Element[]::new);
        return BinaryTupleSchema.create((BinaryTupleSchema.Element[])elements);
    }

    @Override
    public UUID id() {
        return this.id;
    }

    public List<SortedIndexColumnDescriptor> columns() {
        return this.columns;
    }

    public BinaryTupleSchema binaryTupleSchema() {
        return this.binaryTupleSchema;
    }

    public static class SortedIndexColumnDescriptor
    implements IndexDescriptor.ColumnDescriptor {
        private final String name;
        private final NativeType type;
        private final boolean nullable;
        private final boolean asc;

        public SortedIndexColumnDescriptor(String name, NativeType type, boolean nullable, boolean asc) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.asc = asc;
        }

        public SortedIndexColumnDescriptor(ColumnView tableColumnView, IndexColumnView indexColumnView) {
            this.name = tableColumnView.name();
            this.type = ConfigurationToSchemaDescriptorConverter.convert((ColumnTypeView)tableColumnView.type());
            this.nullable = tableColumnView.nullable();
            this.asc = indexColumnView.asc();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public NativeType type() {
            return this.type;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public boolean asc() {
            return this.asc;
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }
}

