/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteSingleHashAggregate;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.util.HintUtils;

public class HashAggregateConverterRule {
    public static final RelOptRule SINGLE = new HashSingleAggregateConverterRule();
    public static final RelOptRule MAP_REDUCE = new HashMapReduceAggregateConverterRule();

    private HashAggregateConverterRule() {
    }

    private static class HashMapReduceAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        HashMapReduceAggregateConverterRule() {
            super(LogicalAggregate.class, "HashMapReduceAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            RelNode input = HashMapReduceAggregateConverterRule.convert((RelNode)agg.getInput(), (RelTraitSet)inTrait);
            IgniteMapHashAggregate map = new IgniteMapHashAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.random()), input, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            return new IgniteReduceHashAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), HashMapReduceAggregateConverterRule.convert((RelNode)map, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList(), agg.getRowType());
        }
    }

    private static class HashSingleAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        HashSingleAggregateConverterRule() {
            super(LogicalAggregate.class, "HashSingleAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelNode input = HashSingleAggregateConverterRule.convert((RelNode)agg.getInput(), (RelTraitSet)inTrait);
            return new IgniteSingleHashAggregate(cluster, outTrait, input, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }
    }
}

