/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.sql.engine.prepare;

import java.io.Serializable;
import java.util.UUID;

/**
 * Unique identifier of a query plan.
 *
 * <p>This identifier consists of unique identifier randomly generated by particular
 * instance of {@link PrepareService} and monotonically increasing plan number within this instance.
 */
public class PlanId implements Serializable {
    private static final long serialVersionUID = -7944926799869032327L;

    private final UUID prepareServiceId;
    private final long planNumber;

    /** Constructor. */
    public PlanId(UUID prepareServiceId, long planNumber) {
        this.prepareServiceId = prepareServiceId;
        this.planNumber = planNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PlanId planId1 = (PlanId) o;

        return planNumber == planId1.planNumber
                && prepareServiceId.equals(planId1.prepareServiceId);
    }

    @Override
    public int hashCode() {
        int result = prepareServiceId.hashCode();
        result = 31 * result + (int) (planNumber ^ (planNumber >>> 32));
        return result;
    }
}
