/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tostring;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.tostring.FieldDescriptor;
import org.apache.ignite.internal.tostring.IgniteStringifier;
import org.apache.ignite.internal.tostring.Stringifier;
import org.apache.ignite.internal.tostring.ToStringUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

class ClassDescriptor {
    private final String name;
    @Nullable
    private final Stringifier<?> stringifier;
    private final ArrayList<FieldDescriptor> fields = new ArrayList();

    ClassDescriptor(Class<?> cls) {
        IgniteStringifier igniteStringifier = cls.getAnnotation(IgniteStringifier.class);
        if (igniteStringifier == null) {
            this.name = cls.getSimpleName();
            this.stringifier = null;
        } else {
            this.name = "".equals(igniteStringifier.name()) ? cls.getSimpleName() : igniteStringifier.name();
            this.stringifier = ToStringUtils.createStringifier(igniteStringifier.value());
        }
    }

    void addField(FieldDescriptor field) {
        assert (field != null);
        this.fields.add(field);
    }

    void sortFields() {
        this.fields.trimToSize();
        this.fields.sort(Comparator.comparingInt(FieldDescriptor::getOrder));
    }

    String getName() {
        return this.name;
    }

    List<FieldDescriptor> getFields() {
        return this.fields;
    }

    @Nullable
    Stringifier<?> getStringifier() {
        return this.stringifier;
    }
}

