/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tx;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;
import org.apache.ignite.tx.TransactionOptions;

public interface IgniteTransactions {
    default public Transaction begin() {
        return this.begin(null);
    }

    public Transaction begin(@Nullable TransactionOptions var1);

    default public CompletableFuture<Transaction> beginAsync() {
        return this.beginAsync(null);
    }

    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions var1);

    default public void runInTransaction(Consumer<Transaction> clo) throws TransactionException {
        this.runInTransaction(clo, null);
    }

    default public void runInTransaction(Consumer<Transaction> clo, @Nullable TransactionOptions options) throws TransactionException {
        Objects.requireNonNull(clo);
        this.runInTransaction((Transaction tx) -> {
            clo.accept((Transaction)tx);
            return null;
        }, options);
    }

    default public <T> T runInTransaction(Function<Transaction, T> clo) throws TransactionException {
        return this.runInTransaction(clo, null);
    }

    default public <T> T runInTransaction(Function<Transaction, T> clo, @Nullable TransactionOptions options) throws TransactionException {
        Objects.requireNonNull(clo);
        Transaction tx = this.begin(options);
        try {
            T ret = clo.apply(tx);
            tx.commit();
            return ret;
        }
        catch (Throwable t2) {
            try {
                tx.rollback();
            }
            catch (Exception e) {
                t2.addSuppressed(e);
            }
            throw t2;
        }
    }

    default public <T> CompletableFuture<T> runInTransactionAsync(Function<Transaction, CompletableFuture<T>> clo) {
        return this.runInTransactionAsync(clo, null);
    }

    default public <T> CompletableFuture<T> runInTransactionAsync(Function<Transaction, CompletableFuture<T>> clo, @Nullable TransactionOptions options) {
        Objects.requireNonNull(clo);
        return this.beginAsync(options).thenCompose(tx -> {
            try {
                return ((CompletableFuture)((CompletableFuture)((CompletableFuture)clo.apply((Transaction)tx)).handle((res, e) -> {
                    if (e != null) {
                        return ((CompletableFuture)tx.rollbackAsync().exceptionally(e0 -> {
                            e.addSuppressed((Throwable)e0);
                            return null;
                        })).thenCompose(ignored -> CompletableFuture.failedFuture(e));
                    }
                    return CompletableFuture.completedFuture(res);
                })).thenCompose(Function.identity())).thenCompose(val -> tx.commitAsync().thenApply(ignored -> val));
            }
            catch (Exception e2) {
                return ((CompletableFuture)tx.rollbackAsync().exceptionally(e0 -> {
                    e2.addSuppressed((Throwable)e0);
                    return null;
                })).thenCompose(ignored -> CompletableFuture.failedFuture(e2));
            }
        });
    }
}

