/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateEnum;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessageSerializer;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class LocalPartitionStateMessageImpl
implements LocalPartitionStateMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 100;
    @IgniteToStringInclude
    private final long estimatedRows;
    @IgniteToStringInclude
    private final long logIndex;
    @IgniteToStringInclude
    private final TablePartitionIdMessage partitionId;
    @IgniteToStringInclude
    private final LocalPartitionStateEnum state;

    private LocalPartitionStateMessageImpl(long estimatedRows, long logIndex, TablePartitionIdMessage partitionId, LocalPartitionStateEnum state) {
        this.estimatedRows = estimatedRows;
        this.logIndex = logIndex;
        this.partitionId = partitionId;
        this.state = state;
    }

    @Override
    public long estimatedRows() {
        return this.estimatedRows;
    }

    @Override
    public long logIndex() {
        return this.logIndex;
    }

    @Override
    public TablePartitionIdMessage partitionId() {
        return this.partitionId;
    }

    @Override
    public LocalPartitionStateEnum state() {
        return this.state;
    }

    public MessageSerializer serializer() {
        return LocalPartitionStateMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(LocalPartitionStateMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 100;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LocalPartitionStateMessageImpl otherMessage = (LocalPartitionStateMessageImpl)other;
        return Objects.equals(this.partitionId, otherMessage.partitionId) && Objects.equals((Object)this.state, (Object)otherMessage.state) && this.estimatedRows == otherMessage.estimatedRows && this.logIndex == otherMessage.logIndex;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.estimatedRows, this.logIndex, this.partitionId, this.state});
        return result;
    }

    public LocalPartitionStateMessageImpl clone() {
        try {
            return (LocalPartitionStateMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static LocalPartitionStateMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitionId != null) {
            this.partitionId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitionId != null) {
            this.partitionId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements LocalPartitionStateMessageBuilder {
        private long estimatedRows;
        private long logIndex;
        private TablePartitionIdMessage partitionId;
        private LocalPartitionStateEnum state;

        private Builder() {
        }

        @Override
        public LocalPartitionStateMessageBuilder estimatedRows(long estimatedRows) {
            this.estimatedRows = estimatedRows;
            return this;
        }

        @Override
        public LocalPartitionStateMessageBuilder logIndex(long logIndex) {
            this.logIndex = logIndex;
            return this;
        }

        @Override
        public LocalPartitionStateMessageBuilder partitionId(TablePartitionIdMessage partitionId) {
            Objects.requireNonNull(partitionId, "partitionId is not marked @Nullable");
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public LocalPartitionStateMessageBuilder state(LocalPartitionStateEnum state) {
            Objects.requireNonNull(state, "state is not marked @Nullable");
            this.state = state;
            return this;
        }

        @Override
        public long estimatedRows() {
            return this.estimatedRows;
        }

        @Override
        public long logIndex() {
            return this.logIndex;
        }

        @Override
        public TablePartitionIdMessage partitionId() {
            return this.partitionId;
        }

        @Override
        public LocalPartitionStateEnum state() {
            return this.state;
        }

        @Override
        public LocalPartitionStateMessage build() {
            return new LocalPartitionStateMessageImpl(this.estimatedRows, this.logIndex, Objects.requireNonNull(this.partitionId, "partitionId is not marked @Nullable"), Objects.requireNonNull(this.state, "state is not marked @Nullable"));
        }
    }
}

