/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.streamer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class StreamerBuffer<T> {
    private final int capacity;
    private final Consumer<List<T>> flusher;
    private List<T> buf;
    private boolean closed;

    StreamerBuffer(int capacity, Consumer<List<T>> flusher) {
        this.capacity = capacity;
        this.flusher = flusher;
        this.buf = new ArrayList<T>(capacity);
    }

    synchronized void add(T item) {
        if (this.closed) {
            throw new IllegalStateException("Streamer is closed, can't add items.");
        }
        this.buf.add(item);
        if (this.buf.size() >= this.capacity) {
            this.flusher.accept(this.buf);
            this.buf = new ArrayList<T>(this.capacity);
        }
    }

    synchronized void flushAndClose() {
        if (this.closed) {
            throw new IllegalStateException("Streamer is already closed.");
        }
        this.closed = true;
        if (!this.buf.isEmpty()) {
            this.flusher.accept(this.buf);
        }
    }

    synchronized void flush() {
        if (this.closed || this.buf.isEmpty()) {
            return;
        }
        this.flusher.accept(this.buf);
        this.buf = new ArrayList<T>(this.capacity);
    }

    synchronized void forEach(Consumer<T> consumer) {
        if (this.closed) {
            return;
        }
        this.buf.forEach(consumer);
    }
}

