/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.cluster.metric;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.cluster.metric.ClusterMetricSourceEnableCall;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.metric.MetricSourceMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="disable", description={"Disables cluster metric source"})
public class ClusterMetricSourceDisableReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private MetricSourceMixin metricSource;
    @Inject
    private ClusterMetricSourceEnableCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this.metricSource::buildDisableCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot disable metrics")).print());
    }
}

