/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.internal.distributionzones.AugmentationSerializer;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class TopologyAugmentationMapSerializer
extends VersionedSerializer<ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation>> {
    public static final TopologyAugmentationMapSerializer INSTANCE = new TopologyAugmentationMapSerializer();
    private final AugmentationSerializer augmentationSerializer = AugmentationSerializer.INSTANCE;

    protected void writeExternalData(ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation> map, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)map.size());
        for (Map.Entry<Long, DistributionZoneManager.Augmentation> entry : map.entrySet()) {
            out.writeVarInt(entry.getKey().longValue());
            this.augmentationSerializer.writeExternal(entry.getValue(), out);
        }
    }

    protected ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation> readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation> map = new ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation>();
        for (int i = 0; i < length; ++i) {
            map.put(in.readVarInt(), (DistributionZoneManager.Augmentation)this.augmentationSerializer.readExternal(in));
        }
        return map;
    }

    public static byte[] serialize(ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation> map) {
        return VersionedSerialization.toBytes(map, (VersionedSerializer)INSTANCE);
    }

    public static ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation> deserialize(byte[] bytes) {
        return (ConcurrentSkipListMap)VersionedSerialization.fromBytes((byte[])bytes, (VersionedSerializer)INSTANCE);
    }
}

