/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.partitiondistribution.Assignments;

public class AssignmentUtil {
    public static int[] partitionIds(Set<Integer> partitionIds, int numberOfPartitions) {
        IntStream partitionIdsStream = partitionIds.isEmpty() ? IntStream.range(0, numberOfPartitions) : partitionIds.stream().mapToInt(Integer::intValue);
        return partitionIdsStream.toArray();
    }

    public static int[] partitionIds(int numberOfPartitions) {
        return AssignmentUtil.partitionIds(Set.of(), numberOfPartitions);
    }

    public static CompletableFuture<Map<Integer, Assignments>> metastoreAssignments(MetaStorageManager metaStorageManager, int[] partitionIds, Function<Integer, ByteArray> keyForPartition) {
        HashMap<ByteArray, Integer> partitionKeysToPartitionNumber = new HashMap<ByteArray, Integer>();
        for (int partitionId : partitionIds) {
            partitionKeysToPartitionNumber.put(keyForPartition.apply(partitionId), partitionId);
        }
        return metaStorageManager.getAll(partitionKeysToPartitionNumber.keySet()).thenApply(entries -> {
            if (entries.isEmpty()) {
                return Map.of();
            }
            HashMap<Integer, Assignments> result = new HashMap<Integer, Assignments>();
            for (Map.Entry mapEntry : entries.entrySet()) {
                Entry entry = (Entry)mapEntry.getValue();
                if (entry.empty() || entry.tombstone()) continue;
                result.put((Integer)partitionKeysToPartitionNumber.get(mapEntry.getKey()), Assignments.fromBytes((byte[])entry.value()));
            }
            return result.isEmpty() ? Map.of() : result;
        });
    }
}

