/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.streamer.StreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;

abstract class AbstractClientStreamerPartitionAwarenessProvider<T>
implements StreamerPartitionAwarenessProvider<T, Integer> {
    private final SchemaRegistry schemaReg;
    private final int partitions;

    AbstractClientStreamerPartitionAwarenessProvider(SchemaRegistry schemaReg, int partitions) {
        assert (schemaReg != null);
        this.schemaReg = schemaReg;
        this.partitions = partitions;
    }

    public Integer partition(T item) {
        int colocationHash = this.colocationHash(this.schemaReg.lastKnownSchema(), item);
        return IgniteUtils.safeAbs((int)colocationHash) % this.partitions;
    }

    abstract int colocationHash(SchemaDescriptor var1, T var2);

    public CompletableFuture<Void> refreshAsync() {
        return CompletableFutures.nullCompletedFuture();
    }
}

