/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequest;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequestType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CompletableFutures;

class ManualGroupRestartRequest
implements DisasterRecoveryRequest {
    private final UUID operationId;
    private final int zoneId;
    private final int tableId;
    private final Set<Integer> partitionIds;
    private final Set<String> nodeNames;
    private final long assignmentsTimestamp;

    ManualGroupRestartRequest(UUID operationId, int zoneId, int tableId, Set<Integer> partitionIds, Set<String> nodeNames, long assignmentsTimestamp) {
        this.operationId = operationId;
        this.zoneId = zoneId;
        this.tableId = tableId;
        this.partitionIds = Set.copyOf(partitionIds);
        this.nodeNames = Set.copyOf(nodeNames);
        this.assignmentsTimestamp = assignmentsTimestamp;
    }

    @Override
    public UUID operationId() {
        return this.operationId;
    }

    @Override
    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public DisasterRecoveryRequestType type() {
        return DisasterRecoveryRequestType.MULTI_NODE;
    }

    public int tableId() {
        return this.tableId;
    }

    public Set<Integer> partitionIds() {
        return this.partitionIds;
    }

    public Set<String> nodeNames() {
        return this.nodeNames;
    }

    long assignmentsTimestamp() {
        return this.assignmentsTimestamp;
    }

    @Override
    public CompletableFuture<Void> handle(DisasterRecoveryManager disasterRecoveryManager, long revision, HybridTimestamp timestamp) {
        if (!this.nodeNames.isEmpty() && !this.nodeNames.contains(disasterRecoveryManager.localNode().name())) {
            return CompletableFutures.nullCompletedFuture();
        }
        ArrayList restartFutures = new ArrayList();
        disasterRecoveryManager.raftManager.forEach((raftNodeId, raftGroupService) -> {
            TablePartitionId groupId;
            if (raftNodeId.groupId() instanceof TablePartitionId && (groupId = (TablePartitionId)raftNodeId.groupId()).tableId() == this.tableId && this.partitionIds.contains(groupId.partitionId())) {
                restartFutures.add(disasterRecoveryManager.tableManager.restartPartition(groupId, revision, this.assignmentsTimestamp));
            }
        });
        return restartFutures.isEmpty() ? CompletableFutures.nullCompletedFuture() : CompletableFuture.allOf((CompletableFuture[])restartFutures.toArray(CompletableFuture[]::new));
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

