/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.network.messages;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.network.messages.ClusterStateMessage;
import org.apache.ignite.internal.cluster.management.network.messages.ClusterStateMessageBuilder;
import org.apache.ignite.internal.cluster.management.network.messages.ClusterStateMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ClusterStateMessageImpl
implements ClusterStateMessage,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final ClusterState clusterState;

    private ClusterStateMessageImpl(ClusterState clusterState) {
        this.clusterState = clusterState;
    }

    @Override
    public ClusterState clusterState() {
        return this.clusterState;
    }

    public MessageSerializer serializer() {
        return ClusterStateMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(ClusterStateMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClusterStateMessageImpl otherMessage = (ClusterStateMessageImpl)other;
        return Objects.equals(this.clusterState, otherMessage.clusterState);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterState);
        return result;
    }

    public ClusterStateMessageImpl clone() {
        try {
            return (ClusterStateMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ClusterStateMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterState != null) {
            this.clusterState.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterState != null) {
            this.clusterState.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ClusterStateMessageBuilder {
        private ClusterState clusterState;

        private Builder() {
        }

        @Override
        public ClusterStateMessageBuilder clusterState(ClusterState clusterState) {
            Objects.requireNonNull(clusterState, "clusterState is not marked @Nullable");
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public ClusterState clusterState() {
            return this.clusterState;
        }

        @Override
        public ClusterStateMessage build() {
            return new ClusterStateMessageImpl(Objects.requireNonNull(this.clusterState, "clusterState is not marked @Nullable"));
        }
    }
}

