/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.calcite.rel.core.TableModify;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.util.RowTypeUtils;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.Pair;
import org.jetbrains.annotations.Nullable;

public class ModifyNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private static final RowSchema MODIFY_RESULT = RowSchema.builder().addField(NativeTypes.INT64).build();
    private final TableModify.Operation modifyOp;
    private final UpdatableTable table;
    @Nullable
    private final List<String> updateColumns;
    private final int @Nullable [] mapping;
    private final long sourceId;
    private final int[] insertRowMapping;
    private final RowHandler.RowFactory<RowT> mappedRowFactory;
    private final RowHandler.RowFactory<RowT> mappedInsertRowFactory;
    private List<RowT> rows = new ArrayList<RowT>(100);
    private long updatedRows;
    private int waiting;
    private int requested;
    private boolean inFlightUpdate;

    public ModifyNode(ExecutionContext<RowT> ctx, UpdatableTable table, long sourceId, TableModify.Operation op, @Nullable List<String> updateColumns, RowHandler.RowFactory<RowT> inputRowFactory) {
        super(ctx);
        this.table = table;
        this.sourceId = sourceId;
        this.modifyOp = op;
        this.updateColumns = updateColumns;
        RowSchema rowSchema = inputRowFactory.rowSchema();
        int fullRowSize = rowSchema.fields().size();
        this.mapping = ModifyNode.mapping(table.descriptor(), updateColumns, fullRowSize);
        this.insertRowMapping = (int[])(op == TableModify.Operation.INSERT || op == TableModify.Operation.MERGE ? StreamSupport.stream(table.descriptor().spliterator(), false).filter(Predicate.not(ColumnDescriptor::virtual)).mapToInt(ColumnDescriptor::logicalIndex).toArray() : null);
        RowSchema mappedRowSchema = this.mapping != null ? RowSchema.map(rowSchema, this.mapping) : rowSchema;
        RowSchema mappedInsertRowSchema = this.insertRowMapping != null ? RowSchema.map(rowSchema, this.insertRowMapping) : rowSchema;
        this.mappedRowFactory = ctx.rowHandler().factory(mappedRowSchema);
        this.mappedInsertRowFactory = ctx.rowHandler().factory(mappedInsertRowSchema);
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        this.requestNextBatchIfNeeded();
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        this.rows.add(row);
        assert (this.rows.size() <= 100);
        if (this.needToFlush()) {
            this.flushTuples();
        }
        this.requestNextBatchIfNeeded();
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        if (this.needToFlush()) {
            this.flushTuples();
        } else {
            this.tryEnd();
        }
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private void requestNextBatchIfNeeded() throws Exception {
        if (this.waiting == 0 && this.rows.isEmpty()) {
            this.waiting = 100;
            this.source().request(100);
        }
    }

    private void tryEnd() throws Exception {
        assert (this.downstream() != null);
        if (this.waiting == -1 && this.requested > 0 && !this.inFlightUpdate && this.rows.isEmpty()) {
            this.downstream().push(this.context().rowHandler().factory(MODIFY_RESULT).create(this.updatedRows));
            this.requested = 0;
            this.downstream().end();
        }
    }

    private void flushTuples() {
        CompletableFuture<Object> modifyResult;
        assert (!CollectionUtils.nullOrEmpty(this.rows));
        this.inFlightUpdate = true;
        List<RowT> rows = this.rows;
        this.rows = new ArrayList<RowT>(100);
        ColocationGroup colocationGroup = this.context().group(this.sourceId);
        assert (colocationGroup != null) : "No colocation group for sourceId#" + this.sourceId;
        switch (this.modifyOp) {
            case INSERT: {
                modifyResult = this.table.insertAll(this.context(), rows, colocationGroup);
                break;
            }
            case UPDATE: {
                this.inlineUpdates(rows);
                modifyResult = this.table.upsertAll(this.context(), rows, colocationGroup);
                break;
            }
            case MERGE: {
                Pair<@Nullable List<RowT>, @Nullable List<RowT>> split = this.splitMerge(rows);
                ArrayList mergeParts = new ArrayList(2);
                if (split.getFirst() != null) {
                    mergeParts.add(this.table.insertAll(this.context(), (List)split.getFirst(), colocationGroup));
                }
                if (split.getSecond() != null) {
                    mergeParts.add(this.table.upsertAll(this.context(), (List)split.getSecond(), colocationGroup));
                }
                modifyResult = CompletableFuture.allOf((CompletableFuture[])mergeParts.toArray(CompletableFuture[]::new));
                break;
            }
            case DELETE: {
                modifyResult = this.table.deleteAll(this.context(), rows, colocationGroup);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.modifyOp.name());
            }
        }
        modifyResult.whenComplete((r, e) -> this.context().execute(() -> {
            if (e != null) {
                this.onError((Throwable)e);
                return;
            }
            this.inFlightUpdate = false;
            this.updatedRows += (long)rows.size();
            if (this.needToFlush()) {
                this.flushTuples();
            }
            this.requestNextBatchIfNeeded();
            this.tryEnd();
        }, this::onError));
    }

    private boolean needToFlush() {
        return !this.inFlightUpdate && (this.rows.size() >= 100 || !this.rows.isEmpty() && this.waiting == -1);
    }

    private void inlineUpdates(List<RowT> rows) {
        if (this.mapping == null) {
            return;
        }
        assert (this.updateColumns != null);
        rows.replaceAll(row -> this.mappedRowFactory.map(row, this.mapping));
    }

    private Pair<@Nullable List<RowT>, @Nullable List<RowT>> splitMerge(List<RowT> rows) {
        List<RowT> rowsToUpdate;
        RowHandler<RowT> handler = this.context().rowHandler();
        if (CollectionUtils.nullOrEmpty(this.updateColumns)) {
            return new Pair(rows, null);
        }
        assert (this.mapping != null);
        ArrayList<RowT> rowsToInsert = null;
        int rowSize = handler.columnCount(rows.get(0));
        int fullRowOffset = rowSize - (this.mapping.length + this.updateColumns.size());
        if (!this.hasUpsertSemantic(rowSize)) {
            rowsToUpdate = rows;
        } else {
            rowsToInsert = new ArrayList<RowT>();
            rowsToUpdate = new ArrayList<RowT>();
            for (RowT row2 : rows) {
                boolean insertRow = true;
                for (int i = fullRowOffset; i < fullRowOffset + this.mapping.length; ++i) {
                    if (handler.isNull(i, row2)) continue;
                    insertRow = false;
                    break;
                }
                if (insertRow) {
                    rowsToInsert.add(row2);
                    continue;
                }
                rowsToUpdate.add(row2);
            }
            if (CollectionUtils.nullOrEmpty(rowsToInsert)) {
                rowsToInsert = null;
            }
            if (CollectionUtils.nullOrEmpty(rowsToUpdate)) {
                rowsToUpdate = null;
            }
        }
        if (rowsToInsert != null) {
            rowsToInsert.replaceAll(row -> this.mappedInsertRowFactory.map(row, this.insertRowMapping));
        }
        if (rowsToUpdate != null) {
            this.inlineUpdates(rowsToUpdate);
        }
        return new Pair(rowsToInsert, rowsToUpdate);
    }

    private boolean hasUpsertSemantic(int rowSize) {
        return this.mapping != null && this.updateColumns != null && rowSize > this.mapping.length + this.updateColumns.size();
    }

    private static int @Nullable [] mapping(TableDescriptor descriptor, @Nullable List<String> updateColumns, int fullRowSize) {
        int i;
        if (updateColumns == null) {
            return null;
        }
        int columnCount = RowTypeUtils.storedRowsCount(descriptor);
        int mergeOffset = 0;
        if (fullRowSize == columnCount * 2 + updateColumns.size()) {
            mergeOffset = columnCount;
        }
        int[] mapping = new int[columnCount];
        for (i = 0; i < columnCount; ++i) {
            mapping[i] = i + mergeOffset;
        }
        for (i = 0; i < updateColumns.size(); ++i) {
            String columnName = updateColumns.get(i);
            ColumnDescriptor columnDescriptor = descriptor.columnDescriptor(columnName);
            assert (!columnDescriptor.virtual()) : "Virtual column can't be updated";
            mapping[columnDescriptor.logicalIndex()] = columnCount + i + mergeOffset;
        }
        return mapping;
    }
}

