/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryRowConverter;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.sql.engine.exec.VirtualColumn;
import org.apache.ignite.internal.sql.engine.util.FieldDeserializingProjectedTuple;

public class ExtendedFieldDeserializingProjectedTuple
extends FieldDeserializingProjectedTuple {
    private final Int2ObjectMap<VirtualColumn> extraColumns;

    public ExtendedFieldDeserializingProjectedTuple(BinaryTupleSchema schema, InternalTuple delegate, int[] projection, List<VirtualColumn> extraColumns) {
        super(schema, delegate, projection);
        this.extraColumns = new Int2ObjectOpenHashMap(extraColumns.size());
        extraColumns.forEach(c -> this.extraColumns.put(c.columnIndex(), c));
    }

    @Override
    protected void normalize() {
        BinaryTupleBuilder builder = new BinaryTupleBuilder(this.projection.length, 32, false);
        int[] newProjection = new int[this.projection.length];
        for (int i = 0; i < this.projection.length; ++i) {
            int col = this.projection[i];
            newProjection[i] = i;
            if (this.extraColumns.containsKey(col)) {
                VirtualColumn column = (VirtualColumn)this.extraColumns.get(col);
                BinaryRowConverter.appendValue((BinaryTupleBuilder)builder, (BinaryTupleSchema.Element)new BinaryTupleSchema.Element(column.type(), true), column.value());
                continue;
            }
            BinaryTupleSchema.Element element = this.schema.element(col);
            BinaryRowConverter.appendValue((BinaryTupleBuilder)builder, (BinaryTupleSchema.Element)element, (Object)this.schema.value(this.delegate, col));
        }
        this.delegate = new BinaryTuple(this.projection.length, builder.build());
        this.projection = newProjection;
        this.extraColumns.clear();
    }

    private boolean isExtraColumn(int col) {
        return this.extraColumns.containsKey(this.projection[col]);
    }

    private VirtualColumn extraColumn(int col) {
        return (VirtualColumn)this.extraColumns.get(this.projection[col]);
    }

    @Override
    public boolean hasNullValue(int col) {
        if (this.isExtraColumn(col)) {
            return this.extraColumn(col).value() == null;
        }
        return super.hasNullValue(col);
    }

    @Override
    public boolean booleanValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Boolean)this.extraColumn(col).value();
        }
        return super.booleanValue(col);
    }

    @Override
    public Boolean booleanValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Boolean)this.extraColumn(col).value();
        }
        return super.booleanValueBoxed(col);
    }

    @Override
    public byte byteValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Byte)this.extraColumn(col).value();
        }
        return super.byteValue(col);
    }

    @Override
    public Byte byteValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Byte)this.extraColumn(col).value();
        }
        return super.byteValueBoxed(col);
    }

    @Override
    public short shortValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Short)this.extraColumn(col).value();
        }
        return super.shortValue(col);
    }

    @Override
    public Short shortValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Short)this.extraColumn(col).value();
        }
        return super.shortValueBoxed(col);
    }

    @Override
    public int intValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Integer)this.extraColumn(col).value();
        }
        return super.intValue(col);
    }

    @Override
    public Integer intValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Integer)this.extraColumn(col).value();
        }
        return super.intValueBoxed(col);
    }

    @Override
    public long longValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Long)this.extraColumn(col).value();
        }
        return super.longValue(col);
    }

    @Override
    public Long longValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Long)this.extraColumn(col).value();
        }
        return super.longValueBoxed(col);
    }

    @Override
    public float floatValue(int col) {
        if (this.isExtraColumn(col)) {
            return ((Float)this.extraColumn(col).value()).floatValue();
        }
        return super.floatValue(col);
    }

    @Override
    public Float floatValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Float)this.extraColumn(col).value();
        }
        return super.floatValueBoxed(col);
    }

    @Override
    public double doubleValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Double)this.extraColumn(col).value();
        }
        return super.doubleValue(col);
    }

    @Override
    public Double doubleValueBoxed(int col) {
        if (this.isExtraColumn(col)) {
            return (Double)this.extraColumn(col).value();
        }
        return super.doubleValueBoxed(col);
    }

    @Override
    public BigDecimal decimalValue(int col, int decimalScale) {
        if (this.isExtraColumn(col)) {
            return (BigDecimal)this.extraColumn(col).value();
        }
        return super.decimalValue(col, decimalScale);
    }

    @Override
    public String stringValue(int col) {
        if (this.isExtraColumn(col)) {
            return (String)this.extraColumn(col).value();
        }
        return super.stringValue(col);
    }

    @Override
    public byte[] bytesValue(int col) {
        if (this.isExtraColumn(col)) {
            return (byte[])this.extraColumn(col).value();
        }
        return super.bytesValue(col);
    }

    @Override
    public UUID uuidValue(int col) {
        if (this.isExtraColumn(col)) {
            return (UUID)this.extraColumn(col).value();
        }
        return super.uuidValue(col);
    }

    @Override
    public LocalDate dateValue(int col) {
        if (this.isExtraColumn(col)) {
            return (LocalDate)this.extraColumn(col).value();
        }
        return super.dateValue(col);
    }

    @Override
    public LocalTime timeValue(int col) {
        if (this.isExtraColumn(col)) {
            return (LocalTime)this.extraColumn(col).value();
        }
        return super.timeValue(col);
    }

    @Override
    public LocalDateTime dateTimeValue(int col) {
        if (this.isExtraColumn(col)) {
            return (LocalDateTime)this.extraColumn(col).value();
        }
        return super.dateTimeValue(col);
    }

    @Override
    public Instant timestampValue(int col) {
        if (this.isExtraColumn(col)) {
            return (Instant)this.extraColumn(col).value();
        }
        return super.timestampValue(col);
    }
}

