/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;

public class ThreadPoolsManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(ThreadPoolsManager.class);
    private final ExecutorService tableIoExecutor;
    private final ExecutorService partitionOperationsExecutor;
    private final ScheduledExecutorService commonScheduler;

    public ThreadPoolsManager(String nodeName) {
        int cpus = Runtime.getRuntime().availableProcessors();
        this.tableIoExecutor = new ThreadPoolExecutor(Math.min(cpus * 3, 25), Integer.MAX_VALUE, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create((String)nodeName, (String)"tableManager-io", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        int partitionsOperationsThreads = Math.min(cpus * 3, 25);
        this.partitionOperationsExecutor = Executors.newFixedThreadPool(partitionsOperationsThreads, IgniteThreadFactory.create((String)nodeName, (String)"partition-operations", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE, ThreadOperation.TX_STATE_STORAGE_ACCESS, ThreadOperation.PROCESS_RAFT_REQ}));
        this.commonScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"common-scheduler", (IgniteLogger)LOG));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.tableIoExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.partitionOperationsExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.commonScheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    public ExecutorService tableIoExecutor() {
        return this.tableIoExecutor;
    }

    public ExecutorService partitionOperationsExecutor() {
        return this.partitionOperationsExecutor;
    }

    public ScheduledExecutorService commonScheduler() {
        return this.commonScheduler;
    }
}

