/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.storage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorageListener;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.apache.ignite.internal.configuration.util.ConfigurationSerializationUtil;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;

public class LocalConfigurationStorage
implements ConfigurationStorage {
    private static final String LOC_PREFIX = "loc-cfg.";
    private static final ByteArray VERSION_KEY = new ByteArray("loc-cfg.$version");
    private static final IgniteLogger LOG = Loggers.forClass(LocalConfigurationStorage.class);
    private final VaultManager vaultMgr;
    private final AtomicReference<ConfigurationStorageListener> lsnrRef = new AtomicReference();
    private static final ByteArray LOC_KEYS_START_RANGE = ByteArray.fromString((String)"loc-cfg.");
    private static final ByteArray LOC_KEYS_END_RANGE = ByteArray.fromString((String)StringUtils.incrementLastChar((String)"loc-cfg."));
    private final ExecutorService threadPool = Executors.newFixedThreadPool(4, (ThreadFactory)new NamedThreadFactory("loc-cfg", LOG));
    private final InFlightFutures futureTracker = new InFlightFutures();
    private CompletableFuture<Void> writeSerializationFuture = CompletableFutures.nullCompletedFuture();
    private final Object writeSerializationLock = new Object();

    public LocalConfigurationStorage(VaultManager vaultMgr) {
        this.vaultMgr = vaultMgr;
    }

    public void close() {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.futureTracker.cancelInFlightFutures();
    }

    public CompletableFuture<Map<String, ? extends Serializable>> readAllLatest(String prefix) {
        ByteArray rangeStart = new ByteArray(LOC_PREFIX + prefix);
        ByteArray rangeEnd = new ByteArray(StringUtils.incrementLastChar((String)(LOC_PREFIX + prefix)));
        return this.readAll(rangeStart, rangeEnd).thenApply(Data::values);
    }

    public CompletableFuture<Serializable> readLatest(String key) {
        return this.registerFuture(CompletableFuture.supplyAsync(() -> {
            try {
                VaultEntry entry = this.vaultMgr.get(new ByteArray(LOC_PREFIX + key));
                return entry == null ? null : ConfigurationSerializationUtil.fromBytes((byte[])entry.value());
            }
            catch (Exception e) {
                throw new StorageException("Exception while reading vault entry", (Throwable)e);
            }
        }, this.threadPool));
    }

    public CompletableFuture<Data> readDataOnRecovery() {
        return this.readAll(LOC_KEYS_START_RANGE, LOC_KEYS_END_RANGE);
    }

    private CompletableFuture<Data> readAll(ByteArray rangeStart, ByteArray rangeEnd) {
        return this.registerFuture(CompletableFuture.supplyAsync(() -> {
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            long version = 0L;
            try (Cursor cursor = this.vaultMgr.range(rangeStart, rangeEnd);){
                for (VaultEntry entry : cursor) {
                    ByteArray key = entry.key();
                    Serializable value = ConfigurationSerializationUtil.fromBytes((byte[])entry.value());
                    if (key.equals((Object)VERSION_KEY)) {
                        version = (Long)value;
                        continue;
                    }
                    data.put(LocalConfigurationStorage.removePrefix(key), value);
                }
            }
            catch (Exception e) {
                throw new StorageException("Exception when closing a Vault cursor", (Throwable)e);
            }
            return new Data(data, version);
        }, this.threadPool));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> write(Map<String, ? extends Serializable> newValues, long sentVersion) {
        Object object = this.writeSerializationLock;
        synchronized (object) {
            CompletableFuture<Boolean> writeFuture = this.registerFuture((CompletableFuture)((CompletableFuture)this.writeSerializationFuture.thenCompose(v -> this.lastRevision())).thenComposeAsync(version -> {
                if (version != sentVersion) {
                    return CompletableFutures.falseCompletedFuture();
                }
                ConfigurationStorageListener lsnr = this.lsnrRef.get();
                assert (lsnr != null) : "Configuration listener must be initialized before write.";
                HashMap data = IgniteUtils.newHashMap((int)(newValues.size() + 1));
                for (Map.Entry e : newValues.entrySet()) {
                    ByteArray key = ByteArray.fromString((String)(LOC_PREFIX + (String)e.getKey()));
                    data.put(key, e.getValue() == null ? null : ConfigurationSerializationUtil.toBytes(e.getValue()));
                }
                byte[] previousVersion = data.put(VERSION_KEY, ConfigurationSerializationUtil.toBytes((Object)(version + 1L)));
                if (previousVersion != null) {
                    throw new IllegalStateException(String.format("\"%s\" is a reserved key and must not be changed externally", LocalConfigurationStorage.removePrefix(VERSION_KEY)));
                }
                Data entries = new Data(newValues, version + 1L);
                this.vaultMgr.putAll((Map)data);
                return lsnr.onEntriesChanged(entries).thenApply(v -> true);
            }, (Executor)this.threadPool));
            this.writeSerializationFuture = writeFuture.handle((v, e) -> null);
            return writeFuture;
        }
    }

    private static String removePrefix(ByteArray key) {
        return key.toString().substring(LOC_PREFIX.length());
    }

    public void registerConfigurationListener(ConfigurationStorageListener lsnr) {
        if (!this.lsnrRef.compareAndSet(null, lsnr)) {
            LOG.debug("Configuration listener has already been set", new Object[0]);
        }
    }

    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    public CompletableFuture<Long> lastRevision() {
        return this.registerFuture(CompletableFuture.supplyAsync(() -> {
            VaultEntry entry = this.vaultMgr.get(VERSION_KEY);
            return entry == null ? 0L : (Long)ConfigurationSerializationUtil.fromBytes((byte[])entry.value());
        }, this.threadPool));
    }

    public CompletableFuture<Long> localRevision() {
        return this.lastRevision();
    }

    private <T> CompletableFuture<T> registerFuture(CompletableFuture<T> future) {
        this.futureTracker.registerFuture(future);
        return future;
    }
}

